/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.ElasticAccountsClient;
import com.azure.resourcemanager.netapp.fluent.models.ElasticAccountInner;
import com.azure.resourcemanager.netapp.implementation.ElasticAccountImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ElasticAccount;
import com.azure.resourcemanager.netapp.models.ElasticAccounts;

public final class ElasticAccountsImpl
implements ElasticAccounts {
    private static final ClientLogger LOGGER = new ClientLogger(ElasticAccountsImpl.class);
    private final ElasticAccountsClient innerClient;
    private final NetAppFilesManager serviceManager;

    public ElasticAccountsImpl(ElasticAccountsClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ElasticAccount> getByResourceGroupWithResponse(String resourceGroupName, String accountName, Context context) {
        Response<ElasticAccountInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, accountName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ElasticAccountImpl((ElasticAccountInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ElasticAccount getByResourceGroup(String resourceGroupName, String accountName) {
        ElasticAccountInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, accountName);
        if (inner != null) {
            return new ElasticAccountImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String accountName) {
        this.serviceClient().delete(resourceGroupName, accountName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, context);
    }

    @Override
    public PagedIterable<ElasticAccount> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ElasticAccountInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticAccountImpl((ElasticAccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticAccount> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ElasticAccountInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticAccountImpl((ElasticAccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticAccount> list() {
        PagedIterable<ElasticAccountInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticAccountImpl((ElasticAccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticAccount> list(Context context) {
        PagedIterable<ElasticAccountInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticAccountImpl((ElasticAccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public ElasticAccount getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        return (ElasticAccount)this.getByResourceGroupWithResponse(resourceGroupName, accountName, Context.NONE).getValue();
    }

    @Override
    public Response<ElasticAccount> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, accountName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        this.delete(resourceGroupName, accountName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        this.delete(resourceGroupName, accountName, context);
    }

    private ElasticAccountsClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticAccountImpl define(String name) {
        return new ElasticAccountImpl(name, this.manager());
    }
}

