/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.ElasticAccountInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ElasticAccount;
import com.azure.resourcemanager.netapp.models.ElasticAccountProperties;
import com.azure.resourcemanager.netapp.models.ElasticAccountUpdate;
import com.azure.resourcemanager.netapp.models.ElasticAccountUpdateProperties;
import com.azure.resourcemanager.netapp.models.ManagedServiceIdentity;
import java.util.Collections;
import java.util.Map;

public final class ElasticAccountImpl
implements ElasticAccount,
ElasticAccount.Definition,
ElasticAccount.Update {
    private ElasticAccountInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private ElasticAccountUpdate updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ElasticAccountProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ElasticAccountInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticAccountImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ElasticAccount create() {
        this.innerObject = this.serviceManager.serviceClient().getElasticAccounts().createOrUpdate(this.resourceGroupName, this.accountName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ElasticAccount create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticAccounts().createOrUpdate(this.resourceGroupName, this.accountName, this.innerModel(), context);
        return this;
    }

    ElasticAccountImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new ElasticAccountInner();
        this.serviceManager = serviceManager;
        this.accountName = name;
    }

    @Override
    public ElasticAccountImpl update() {
        this.updateBody = new ElasticAccountUpdate();
        return this;
    }

    @Override
    public ElasticAccount apply() {
        this.innerObject = this.serviceManager.serviceClient().getElasticAccounts().update(this.resourceGroupName, this.accountName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public ElasticAccount apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticAccounts().update(this.resourceGroupName, this.accountName, this.updateBody, context);
        return this;
    }

    ElasticAccountImpl(ElasticAccountInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticAccounts");
    }

    @Override
    public ElasticAccount refresh() {
        this.innerObject = (ElasticAccountInner)((Object)this.serviceManager.serviceClient().getElasticAccounts().getByResourceGroupWithResponse(this.resourceGroupName, this.accountName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ElasticAccount refresh(Context context) {
        this.innerObject = (ElasticAccountInner)((Object)this.serviceManager.serviceClient().getElasticAccounts().getByResourceGroupWithResponse(this.resourceGroupName, this.accountName, context).getValue());
        return this;
    }

    @Override
    public ElasticAccountImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ElasticAccountImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ElasticAccountImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBody.withTags(tags);
        return this;
    }

    @Override
    public ElasticAccountImpl withProperties(ElasticAccountProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public ElasticAccountImpl withIdentity(ManagedServiceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateBody.withIdentity(identity);
        return this;
    }

    @Override
    public ElasticAccountImpl withProperties(ElasticAccountUpdateProperties properties) {
        this.updateBody.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

