/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.CachesClient;
import com.azure.resourcemanager.netapp.fluent.models.CacheInner;
import com.azure.resourcemanager.netapp.fluent.models.PeeringPassphrasesInner;
import com.azure.resourcemanager.netapp.implementation.CacheImpl;
import com.azure.resourcemanager.netapp.implementation.PeeringPassphrasesImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.Cache;
import com.azure.resourcemanager.netapp.models.Caches;
import com.azure.resourcemanager.netapp.models.PeeringPassphrases;
import com.azure.resourcemanager.netapp.models.PoolChangeRequest;

public final class CachesImpl
implements Caches {
    private static final ClientLogger LOGGER = new ClientLogger(CachesImpl.class);
    private final CachesClient innerClient;
    private final NetAppFilesManager serviceManager;

    public CachesImpl(CachesClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Cache> getWithResponse(String resourceGroupName, String accountName, String poolName, String cacheName, Context context) {
        Response<CacheInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, poolName, cacheName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CacheImpl((CacheInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Cache get(String resourceGroupName, String accountName, String poolName, String cacheName) {
        CacheInner inner = this.serviceClient().get(resourceGroupName, accountName, poolName, cacheName);
        if (inner != null) {
            return new CacheImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, String cacheName) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, cacheName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, String cacheName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, cacheName, context);
    }

    @Override
    public PagedIterable<Cache> listByCapacityPools(String resourceGroupName, String accountName, String poolName) {
        PagedIterable<CacheInner> inner = this.serviceClient().listByCapacityPools(resourceGroupName, accountName, poolName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CacheImpl((CacheInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Cache> listByCapacityPools(String resourceGroupName, String accountName, String poolName, Context context) {
        PagedIterable<CacheInner> inner = this.serviceClient().listByCapacityPools(resourceGroupName, accountName, poolName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CacheImpl((CacheInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<PeeringPassphrases> listPeeringPassphrasesWithResponse(String resourceGroupName, String accountName, String poolName, String cacheName, Context context) {
        Response<PeeringPassphrasesInner> inner = this.serviceClient().listPeeringPassphrasesWithResponse(resourceGroupName, accountName, poolName, cacheName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PeeringPassphrasesImpl((PeeringPassphrasesInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PeeringPassphrases listPeeringPassphrases(String resourceGroupName, String accountName, String poolName, String cacheName) {
        PeeringPassphrasesInner inner = this.serviceClient().listPeeringPassphrases(resourceGroupName, accountName, poolName, cacheName);
        if (inner != null) {
            return new PeeringPassphrasesImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void poolChange(String resourceGroupName, String accountName, String poolName, String cacheName, PoolChangeRequest body) {
        this.serviceClient().poolChange(resourceGroupName, accountName, poolName, cacheName, body);
    }

    @Override
    public void poolChange(String resourceGroupName, String accountName, String poolName, String cacheName, PoolChangeRequest body, Context context) {
        this.serviceClient().poolChange(resourceGroupName, accountName, poolName, cacheName, body, context);
    }

    @Override
    public Cache getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String cacheName = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        return (Cache)this.getWithResponse(resourceGroupName, accountName, poolName, cacheName, Context.NONE).getValue();
    }

    @Override
    public Response<Cache> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String cacheName = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, poolName, cacheName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String cacheName = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, cacheName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String cacheName = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, cacheName, context);
    }

    private CachesClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public CacheImpl define(String name) {
        return new CacheImpl(name, this.manager());
    }
}

