/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.netapp.fluent.CachesClient;
import com.azure.resourcemanager.netapp.fluent.models.CacheInner;
import com.azure.resourcemanager.netapp.fluent.models.PeeringPassphrasesInner;
import com.azure.resourcemanager.netapp.implementation.NetAppManagementClientImpl;
import com.azure.resourcemanager.netapp.implementation.models.CacheList;
import com.azure.resourcemanager.netapp.models.CacheUpdate;
import com.azure.resourcemanager.netapp.models.PoolChangeRequest;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class CachesClientImpl
implements CachesClient {
    private final CachesService service;
    private final NetAppManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(CachesClientImpl.class);

    CachesClientImpl(NetAppManagementClientImpl client) {
        this.service = (CachesService)RestProxy.create(CachesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CacheInner>> getWithResponseAsync(String resourceGroupName, String accountName, String poolName, String cacheName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, cacheName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CacheInner> getAsync(String resourceGroupName, String accountName, String poolName, String cacheName) {
        return this.getWithResponseAsync(resourceGroupName, accountName, poolName, cacheName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((CacheInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CacheInner> getWithResponse(String resourceGroupName, String accountName, String poolName, String cacheName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, cacheName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CacheInner get(String resourceGroupName, String accountName, String poolName, String cacheName) {
        return (CacheInner)((Object)this.getWithResponse(resourceGroupName, accountName, poolName, cacheName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String accountName, String poolName, String cacheName, CacheInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, cacheName, "application/json", "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String accountName, String poolName, String cacheName, CacheInner body) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, cacheName, "application/json", "application/json", body, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String accountName, String poolName, String cacheName, CacheInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, cacheName, "application/json", "application/json", body, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CacheInner>, CacheInner> beginCreateOrUpdateAsync(String resourceGroupName, String accountName, String poolName, String cacheName, CacheInner body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, accountName, poolName, cacheName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CacheInner.class), (Type)((Object)CacheInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CacheInner>, CacheInner> beginCreateOrUpdate(String resourceGroupName, String accountName, String poolName, String cacheName, CacheInner body) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, accountName, poolName, cacheName, body);
        return this.client.getLroResult(response, (Type)((Object)CacheInner.class), (Type)((Object)CacheInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CacheInner>, CacheInner> beginCreateOrUpdate(String resourceGroupName, String accountName, String poolName, String cacheName, CacheInner body, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, accountName, poolName, cacheName, body, context);
        return this.client.getLroResult(response, (Type)((Object)CacheInner.class), (Type)((Object)CacheInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CacheInner> createOrUpdateAsync(String resourceGroupName, String accountName, String poolName, String cacheName, CacheInner body) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, accountName, poolName, cacheName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CacheInner createOrUpdate(String resourceGroupName, String accountName, String poolName, String cacheName, CacheInner body) {
        return (CacheInner)((Object)this.beginCreateOrUpdate(resourceGroupName, accountName, poolName, cacheName, body).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CacheInner createOrUpdate(String resourceGroupName, String accountName, String poolName, String cacheName, CacheInner body, Context context) {
        return (CacheInner)((Object)this.beginCreateOrUpdate(resourceGroupName, accountName, poolName, cacheName, body, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String accountName, String poolName, String cacheName, CacheUpdate body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, cacheName, "application/json", "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String accountName, String poolName, String cacheName, CacheUpdate body) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, cacheName, "application/json", "application/json", body, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String accountName, String poolName, String cacheName, CacheUpdate body, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, cacheName, "application/json", "application/json", body, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CacheInner>, CacheInner> beginUpdateAsync(String resourceGroupName, String accountName, String poolName, String cacheName, CacheUpdate body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, accountName, poolName, cacheName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CacheInner.class), (Type)((Object)CacheInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CacheInner>, CacheInner> beginUpdate(String resourceGroupName, String accountName, String poolName, String cacheName, CacheUpdate body) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, accountName, poolName, cacheName, body);
        return this.client.getLroResult(response, (Type)((Object)CacheInner.class), (Type)((Object)CacheInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CacheInner>, CacheInner> beginUpdate(String resourceGroupName, String accountName, String poolName, String cacheName, CacheUpdate body, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, accountName, poolName, cacheName, body, context);
        return this.client.getLroResult(response, (Type)((Object)CacheInner.class), (Type)((Object)CacheInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CacheInner> updateAsync(String resourceGroupName, String accountName, String poolName, String cacheName, CacheUpdate body) {
        return this.beginUpdateAsync(resourceGroupName, accountName, poolName, cacheName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CacheInner update(String resourceGroupName, String accountName, String poolName, String cacheName, CacheUpdate body) {
        return (CacheInner)((Object)this.beginUpdate(resourceGroupName, accountName, poolName, cacheName, body).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CacheInner update(String resourceGroupName, String accountName, String poolName, String cacheName, CacheUpdate body, Context context) {
        return (CacheInner)((Object)this.beginUpdate(resourceGroupName, accountName, poolName, cacheName, body, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String accountName, String poolName, String cacheName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, cacheName, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String accountName, String poolName, String cacheName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, cacheName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String accountName, String poolName, String cacheName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, cacheName, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String accountName, String poolName, String cacheName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, accountName, poolName, cacheName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String accountName, String poolName, String cacheName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, accountName, poolName, cacheName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String accountName, String poolName, String cacheName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, accountName, poolName, cacheName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String accountName, String poolName, String cacheName) {
        return this.beginDeleteAsync(resourceGroupName, accountName, poolName, cacheName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String accountName, String poolName, String cacheName) {
        this.beginDelete(resourceGroupName, accountName, poolName, cacheName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String accountName, String poolName, String cacheName, Context context) {
        this.beginDelete(resourceGroupName, accountName, poolName, cacheName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CacheInner>> listByCapacityPoolsSinglePageAsync(String resourceGroupName, String accountName, String poolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByCapacityPools(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CacheList)res.getValue()).value(), ((CacheList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CacheInner> listByCapacityPoolsAsync(String resourceGroupName, String accountName, String poolName) {
        return new PagedFlux(() -> this.listByCapacityPoolsSinglePageAsync(resourceGroupName, accountName, poolName), nextLink -> this.listByCapacityPoolsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CacheInner> listByCapacityPoolsSinglePage(String resourceGroupName, String accountName, String poolName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CacheList> res = this.service.listByCapacityPoolsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CacheList)res.getValue()).value(), ((CacheList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CacheInner> listByCapacityPoolsSinglePage(String resourceGroupName, String accountName, String poolName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CacheList> res = this.service.listByCapacityPoolsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CacheList)res.getValue()).value(), ((CacheList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CacheInner> listByCapacityPools(String resourceGroupName, String accountName, String poolName) {
        return new PagedIterable(() -> this.listByCapacityPoolsSinglePage(resourceGroupName, accountName, poolName), nextLink -> this.listByCapacityPoolsNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CacheInner> listByCapacityPools(String resourceGroupName, String accountName, String poolName, Context context) {
        return new PagedIterable(() -> this.listByCapacityPoolsSinglePage(resourceGroupName, accountName, poolName, context), nextLink -> this.listByCapacityPoolsNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PeeringPassphrasesInner>> listPeeringPassphrasesWithResponseAsync(String resourceGroupName, String accountName, String poolName, String cacheName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPeeringPassphrases(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, cacheName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PeeringPassphrasesInner> listPeeringPassphrasesAsync(String resourceGroupName, String accountName, String poolName, String cacheName) {
        return this.listPeeringPassphrasesWithResponseAsync(resourceGroupName, accountName, poolName, cacheName).flatMap(res -> Mono.justOrEmpty((Object)((PeeringPassphrasesInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PeeringPassphrasesInner> listPeeringPassphrasesWithResponse(String resourceGroupName, String accountName, String poolName, String cacheName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.listPeeringPassphrasesSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, cacheName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PeeringPassphrasesInner listPeeringPassphrases(String resourceGroupName, String accountName, String poolName, String cacheName) {
        return (PeeringPassphrasesInner)this.listPeeringPassphrasesWithResponse(resourceGroupName, accountName, poolName, cacheName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> poolChangeWithResponseAsync(String resourceGroupName, String accountName, String poolName, String cacheName, PoolChangeRequest body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.poolChange(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, cacheName, "application/json", "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> poolChangeWithResponse(String resourceGroupName, String accountName, String poolName, String cacheName, PoolChangeRequest body) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.poolChangeSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, cacheName, "application/json", "application/json", body, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> poolChangeWithResponse(String resourceGroupName, String accountName, String poolName, String cacheName, PoolChangeRequest body, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.poolChangeSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, cacheName, "application/json", "application/json", body, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginPoolChangeAsync(String resourceGroupName, String accountName, String poolName, String cacheName, PoolChangeRequest body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.poolChangeWithResponseAsync(resourceGroupName, accountName, poolName, cacheName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginPoolChange(String resourceGroupName, String accountName, String poolName, String cacheName, PoolChangeRequest body) {
        Response<BinaryData> response = this.poolChangeWithResponse(resourceGroupName, accountName, poolName, cacheName, body);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginPoolChange(String resourceGroupName, String accountName, String poolName, String cacheName, PoolChangeRequest body, Context context) {
        Response<BinaryData> response = this.poolChangeWithResponse(resourceGroupName, accountName, poolName, cacheName, body, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> poolChangeAsync(String resourceGroupName, String accountName, String poolName, String cacheName, PoolChangeRequest body) {
        return this.beginPoolChangeAsync(resourceGroupName, accountName, poolName, cacheName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void poolChange(String resourceGroupName, String accountName, String poolName, String cacheName, PoolChangeRequest body) {
        this.beginPoolChange(resourceGroupName, accountName, poolName, cacheName, body).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void poolChange(String resourceGroupName, String accountName, String poolName, String cacheName, PoolChangeRequest body, Context context) {
        this.beginPoolChange(resourceGroupName, accountName, poolName, cacheName, body, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CacheInner>> listByCapacityPoolsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByCapacityPoolsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CacheList)res.getValue()).value(), ((CacheList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CacheInner> listByCapacityPoolsNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CacheList> res = this.service.listByCapacityPoolsNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CacheList)res.getValue()).value(), ((CacheList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CacheInner> listByCapacityPoolsNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CacheList> res = this.service.listByCapacityPoolsNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CacheList)res.getValue()).value(), ((CacheList)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="NetAppManagementClientCaches")
    public static interface CachesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/caches/{cacheName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CacheInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="cacheName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/caches/{cacheName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CacheInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="cacheName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/caches/{cacheName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="cacheName") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") CacheInner var10, Context var11);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/caches/{cacheName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="cacheName") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") CacheInner var10, Context var11);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/caches/{cacheName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="cacheName") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") CacheUpdate var10, Context var11);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/caches/{cacheName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="cacheName") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") CacheUpdate var10, Context var11);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/caches/{cacheName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="cacheName") String var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/caches/{cacheName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="cacheName") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/caches")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CacheList>> listByCapacityPools(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/caches")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CacheList> listByCapacityPoolsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/caches/{cacheName}/listPeeringPassphrases")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PeeringPassphrasesInner>> listPeeringPassphrases(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="cacheName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/caches/{cacheName}/listPeeringPassphrases")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<PeeringPassphrasesInner> listPeeringPassphrasesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="cacheName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/caches/{cacheName}/poolChange")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> poolChange(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="cacheName") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") PoolChangeRequest var10, Context var11);

        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/caches/{cacheName}/poolChange")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> poolChangeSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="cacheName") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") PoolChangeRequest var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CacheList>> listByCapacityPoolsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CacheList> listByCapacityPoolsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

