/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.CacheInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.Cache;
import com.azure.resourcemanager.netapp.models.CacheProperties;
import com.azure.resourcemanager.netapp.models.CacheUpdate;
import com.azure.resourcemanager.netapp.models.CacheUpdateProperties;
import com.azure.resourcemanager.netapp.models.PeeringPassphrases;
import com.azure.resourcemanager.netapp.models.PoolChangeRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class CacheImpl
implements Cache,
Cache.Definition,
Cache.Update {
    private CacheInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String poolName;
    private String cacheName;
    private CacheUpdate updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public CacheProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public List<String> zones() {
        List<String> inner = this.innerModel().zones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public CacheInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public CacheImpl withExistingCapacityPool(String resourceGroupName, String accountName, String poolName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        this.poolName = poolName;
        return this;
    }

    @Override
    public Cache create() {
        this.innerObject = this.serviceManager.serviceClient().getCaches().createOrUpdate(this.resourceGroupName, this.accountName, this.poolName, this.cacheName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Cache create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCaches().createOrUpdate(this.resourceGroupName, this.accountName, this.poolName, this.cacheName, this.innerModel(), context);
        return this;
    }

    CacheImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new CacheInner();
        this.serviceManager = serviceManager;
        this.cacheName = name;
    }

    @Override
    public CacheImpl update() {
        this.updateBody = new CacheUpdate();
        return this;
    }

    @Override
    public Cache apply() {
        this.innerObject = this.serviceManager.serviceClient().getCaches().update(this.resourceGroupName, this.accountName, this.poolName, this.cacheName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public Cache apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCaches().update(this.resourceGroupName, this.accountName, this.poolName, this.cacheName, this.updateBody, context);
        return this;
    }

    CacheImpl(CacheInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "netAppAccounts");
        this.poolName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "capacityPools");
        this.cacheName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "caches");
    }

    @Override
    public Cache refresh() {
        this.innerObject = (CacheInner)((Object)this.serviceManager.serviceClient().getCaches().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.cacheName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Cache refresh(Context context) {
        this.innerObject = (CacheInner)((Object)this.serviceManager.serviceClient().getCaches().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.cacheName, context).getValue());
        return this;
    }

    @Override
    public Response<PeeringPassphrases> listPeeringPassphrasesWithResponse(Context context) {
        return this.serviceManager.caches().listPeeringPassphrasesWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.cacheName, context);
    }

    @Override
    public PeeringPassphrases listPeeringPassphrases() {
        return this.serviceManager.caches().listPeeringPassphrases(this.resourceGroupName, this.accountName, this.poolName, this.cacheName);
    }

    @Override
    public void poolChange(PoolChangeRequest body) {
        this.serviceManager.caches().poolChange(this.resourceGroupName, this.accountName, this.poolName, this.cacheName, body);
    }

    @Override
    public void poolChange(PoolChangeRequest body, Context context) {
        this.serviceManager.caches().poolChange(this.resourceGroupName, this.accountName, this.poolName, this.cacheName, body, context);
    }

    @Override
    public CacheImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public CacheImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public CacheImpl withProperties(CacheProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public CacheImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBody.withTags(tags);
        return this;
    }

    @Override
    public CacheImpl withZones(List<String> zones) {
        this.innerModel().withZones(zones);
        return this;
    }

    @Override
    public CacheImpl withProperties(CacheUpdateProperties properties) {
        this.updateBody.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

