/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.BucketsClient;
import com.azure.resourcemanager.netapp.fluent.models.BucketGenerateCredentialsInner;
import com.azure.resourcemanager.netapp.fluent.models.BucketInner;
import com.azure.resourcemanager.netapp.implementation.BucketGenerateCredentialsImpl;
import com.azure.resourcemanager.netapp.implementation.BucketImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.Bucket;
import com.azure.resourcemanager.netapp.models.BucketCredentialsExpiry;
import com.azure.resourcemanager.netapp.models.BucketGenerateCredentials;
import com.azure.resourcemanager.netapp.models.Buckets;

public final class BucketsImpl
implements Buckets {
    private static final ClientLogger LOGGER = new ClientLogger(BucketsImpl.class);
    private final BucketsClient innerClient;
    private final NetAppFilesManager serviceManager;

    public BucketsImpl(BucketsClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Bucket> getWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, Context context) {
        Response<BucketInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, poolName, volumeName, bucketName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BucketImpl((BucketInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Bucket get(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName) {
        BucketInner inner = this.serviceClient().get(resourceGroupName, accountName, poolName, volumeName, bucketName);
        if (inner != null) {
            return new BucketImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, volumeName, bucketName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, volumeName, bucketName, context);
    }

    @Override
    public PagedIterable<Bucket> list(String resourceGroupName, String accountName, String poolName, String volumeName) {
        PagedIterable<BucketInner> inner = this.serviceClient().list(resourceGroupName, accountName, poolName, volumeName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BucketImpl((BucketInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Bucket> list(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        PagedIterable<BucketInner> inner = this.serviceClient().list(resourceGroupName, accountName, poolName, volumeName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BucketImpl((BucketInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<BucketGenerateCredentials> generateCredentialsWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketCredentialsExpiry body, Context context) {
        Response<BucketGenerateCredentialsInner> inner = this.serviceClient().generateCredentialsWithResponse(resourceGroupName, accountName, poolName, volumeName, bucketName, body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BucketGenerateCredentialsImpl((BucketGenerateCredentialsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public BucketGenerateCredentials generateCredentials(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketCredentialsExpiry body) {
        BucketGenerateCredentialsInner inner = this.serviceClient().generateCredentials(resourceGroupName, accountName, poolName, volumeName, bucketName, body);
        if (inner != null) {
            return new BucketGenerateCredentialsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Bucket getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        String bucketName = ResourceManagerUtils.getValueFromIdByName(id, "buckets");
        if (bucketName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'buckets'.", id)));
        }
        return (Bucket)this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, bucketName, Context.NONE).getValue();
    }

    @Override
    public Response<Bucket> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        String bucketName = ResourceManagerUtils.getValueFromIdByName(id, "buckets");
        if (bucketName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'buckets'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, bucketName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        String bucketName = ResourceManagerUtils.getValueFromIdByName(id, "buckets");
        if (bucketName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'buckets'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, volumeName, bucketName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        String bucketName = ResourceManagerUtils.getValueFromIdByName(id, "buckets");
        if (bucketName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'buckets'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, volumeName, bucketName, context);
    }

    private BucketsClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public BucketImpl define(String name) {
        return new BucketImpl(name, this.manager());
    }
}

