/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.netapp.fluent.BucketsClient;
import com.azure.resourcemanager.netapp.fluent.models.BucketGenerateCredentialsInner;
import com.azure.resourcemanager.netapp.fluent.models.BucketInner;
import com.azure.resourcemanager.netapp.implementation.NetAppManagementClientImpl;
import com.azure.resourcemanager.netapp.implementation.models.BucketList;
import com.azure.resourcemanager.netapp.models.BucketCredentialsExpiry;
import com.azure.resourcemanager.netapp.models.BucketPatch;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BucketsClientImpl
implements BucketsClient {
    private final BucketsService service;
    private final NetAppManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(BucketsClientImpl.class);

    BucketsClientImpl(NetAppManagementClientImpl client) {
        this.service = (BucketsService)RestProxy.create(BucketsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BucketInner>> getWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (bucketName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bucketName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, bucketName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BucketInner> getAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName) {
        return this.getWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, bucketName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((BucketInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BucketInner> getWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (bucketName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bucketName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, bucketName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BucketInner get(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName) {
        return (BucketInner)((Object)this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, bucketName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (bucketName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bucketName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, bucketName, "application/json", "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketInner body) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (bucketName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bucketName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, bucketName, "application/json", "application/json", body, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (bucketName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bucketName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, bucketName, "application/json", "application/json", body, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BucketInner>, BucketInner> beginCreateOrUpdateAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketInner body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, bucketName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BucketInner.class), (Type)((Object)BucketInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BucketInner>, BucketInner> beginCreateOrUpdate(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketInner body) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, accountName, poolName, volumeName, bucketName, body);
        return this.client.getLroResult(response, (Type)((Object)BucketInner.class), (Type)((Object)BucketInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BucketInner>, BucketInner> beginCreateOrUpdate(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketInner body, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, accountName, poolName, volumeName, bucketName, body, context);
        return this.client.getLroResult(response, (Type)((Object)BucketInner.class), (Type)((Object)BucketInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BucketInner> createOrUpdateAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketInner body) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, accountName, poolName, volumeName, bucketName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BucketInner createOrUpdate(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketInner body) {
        return (BucketInner)((Object)this.beginCreateOrUpdate(resourceGroupName, accountName, poolName, volumeName, bucketName, body).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BucketInner createOrUpdate(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketInner body, Context context) {
        return (BucketInner)((Object)this.beginCreateOrUpdate(resourceGroupName, accountName, poolName, volumeName, bucketName, body, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketPatch body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (bucketName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bucketName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, bucketName, "application/json", "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketPatch body) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (bucketName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bucketName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, bucketName, "application/json", "application/json", body, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketPatch body, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (bucketName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bucketName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, bucketName, "application/json", "application/json", body, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BucketInner>, BucketInner> beginUpdateAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketPatch body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, bucketName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BucketInner.class), (Type)((Object)BucketInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BucketInner>, BucketInner> beginUpdate(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketPatch body) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, accountName, poolName, volumeName, bucketName, body);
        return this.client.getLroResult(response, (Type)((Object)BucketInner.class), (Type)((Object)BucketInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BucketInner>, BucketInner> beginUpdate(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketPatch body, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, accountName, poolName, volumeName, bucketName, body, context);
        return this.client.getLroResult(response, (Type)((Object)BucketInner.class), (Type)((Object)BucketInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BucketInner> updateAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketPatch body) {
        return this.beginUpdateAsync(resourceGroupName, accountName, poolName, volumeName, bucketName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BucketInner update(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketPatch body) {
        return (BucketInner)((Object)this.beginUpdate(resourceGroupName, accountName, poolName, volumeName, bucketName, body).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BucketInner update(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketPatch body, Context context) {
        return (BucketInner)((Object)this.beginUpdate(resourceGroupName, accountName, poolName, volumeName, bucketName, body, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (bucketName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bucketName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, bucketName, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (bucketName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bucketName is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, bucketName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (bucketName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bucketName is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, bucketName, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, bucketName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, accountName, poolName, volumeName, bucketName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, accountName, poolName, volumeName, bucketName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName) {
        return this.beginDeleteAsync(resourceGroupName, accountName, poolName, volumeName, bucketName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName) {
        this.beginDelete(resourceGroupName, accountName, poolName, volumeName, bucketName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, Context context) {
        this.beginDelete(resourceGroupName, accountName, poolName, volumeName, bucketName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BucketInner>> listSinglePageAsync(String resourceGroupName, String accountName, String poolName, String volumeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BucketList)res.getValue()).value(), ((BucketList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BucketInner> listAsync(String resourceGroupName, String accountName, String poolName, String volumeName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, accountName, poolName, volumeName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BucketInner> listSinglePage(String resourceGroupName, String accountName, String poolName, String volumeName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<BucketList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BucketList)res.getValue()).value(), ((BucketList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BucketInner> listSinglePage(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<BucketList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BucketList)res.getValue()).value(), ((BucketList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BucketInner> list(String resourceGroupName, String accountName, String poolName, String volumeName) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, accountName, poolName, volumeName), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BucketInner> list(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, accountName, poolName, volumeName, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BucketGenerateCredentialsInner>> generateCredentialsWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketCredentialsExpiry body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (bucketName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bucketName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.generateCredentials(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, bucketName, "application/json", "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BucketGenerateCredentialsInner> generateCredentialsAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketCredentialsExpiry body) {
        return this.generateCredentialsWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, bucketName, body).flatMap(res -> Mono.justOrEmpty((Object)((BucketGenerateCredentialsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BucketGenerateCredentialsInner> generateCredentialsWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketCredentialsExpiry body, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (bucketName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bucketName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.generateCredentialsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, bucketName, "application/json", "application/json", body, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BucketGenerateCredentialsInner generateCredentials(String resourceGroupName, String accountName, String poolName, String volumeName, String bucketName, BucketCredentialsExpiry body) {
        return (BucketGenerateCredentialsInner)this.generateCredentialsWithResponse(resourceGroupName, accountName, poolName, volumeName, bucketName, body, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BucketInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BucketList)res.getValue()).value(), ((BucketList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BucketInner> listNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<BucketList> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BucketList)res.getValue()).value(), ((BucketList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BucketInner> listNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<BucketList> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BucketList)res.getValue()).value(), ((BucketList)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="NetAppManagementClientBuckets")
    public static interface BucketsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/buckets/{bucketName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BucketInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @PathParam(value="bucketName") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/buckets/{bucketName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BucketInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @PathParam(value="bucketName") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/buckets/{bucketName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @PathParam(value="bucketName") String var8, @HeaderParam(value="Content-Type") String var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") BucketInner var11, Context var12);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/buckets/{bucketName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @PathParam(value="bucketName") String var8, @HeaderParam(value="Content-Type") String var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") BucketInner var11, Context var12);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/buckets/{bucketName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @PathParam(value="bucketName") String var8, @HeaderParam(value="Content-Type") String var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") BucketPatch var11, Context var12);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/buckets/{bucketName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @PathParam(value="bucketName") String var8, @HeaderParam(value="Content-Type") String var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") BucketPatch var11, Context var12);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/buckets/{bucketName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @PathParam(value="bucketName") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/buckets/{bucketName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @PathParam(value="bucketName") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/buckets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BucketList>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/buckets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BucketList> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/buckets/{bucketName}/generateCredentials")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BucketGenerateCredentialsInner>> generateCredentials(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @PathParam(value="bucketName") String var8, @HeaderParam(value="Content-Type") String var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") BucketCredentialsExpiry var11, Context var12);

        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/buckets/{bucketName}/generateCredentials")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BucketGenerateCredentialsInner> generateCredentialsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @PathParam(value="bucketName") String var8, @HeaderParam(value="Content-Type") String var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") BucketCredentialsExpiry var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BucketList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BucketList> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

