/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.BucketInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.Bucket;
import com.azure.resourcemanager.netapp.models.BucketCredentialsExpiry;
import com.azure.resourcemanager.netapp.models.BucketGenerateCredentials;
import com.azure.resourcemanager.netapp.models.BucketPatch;
import com.azure.resourcemanager.netapp.models.BucketPatchPermissions;
import com.azure.resourcemanager.netapp.models.BucketPermissions;
import com.azure.resourcemanager.netapp.models.BucketServerPatchProperties;
import com.azure.resourcemanager.netapp.models.BucketServerProperties;
import com.azure.resourcemanager.netapp.models.CredentialsStatus;
import com.azure.resourcemanager.netapp.models.FileSystemUser;
import com.azure.resourcemanager.netapp.models.ProvisioningState;

public final class BucketImpl
implements Bucket,
Bucket.Definition,
Bucket.Update {
    private BucketInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String poolName;
    private String volumeName;
    private String bucketName;
    private BucketPatch updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String path() {
        return this.innerModel().path();
    }

    @Override
    public FileSystemUser fileSystemUser() {
        return this.innerModel().fileSystemUser();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public CredentialsStatus status() {
        return this.innerModel().status();
    }

    @Override
    public BucketServerProperties server() {
        return this.innerModel().server();
    }

    @Override
    public BucketPermissions permissions() {
        return this.innerModel().permissions();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public BucketInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public BucketImpl withExistingVolume(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        this.poolName = poolName;
        this.volumeName = volumeName;
        return this;
    }

    @Override
    public Bucket create() {
        this.innerObject = this.serviceManager.serviceClient().getBuckets().createOrUpdate(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.bucketName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Bucket create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBuckets().createOrUpdate(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.bucketName, this.innerModel(), context);
        return this;
    }

    BucketImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new BucketInner();
        this.serviceManager = serviceManager;
        this.bucketName = name;
    }

    @Override
    public BucketImpl update() {
        this.updateBody = new BucketPatch();
        return this;
    }

    @Override
    public Bucket apply() {
        this.innerObject = this.serviceManager.serviceClient().getBuckets().update(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.bucketName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public Bucket apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBuckets().update(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.bucketName, this.updateBody, context);
        return this;
    }

    BucketImpl(BucketInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "netAppAccounts");
        this.poolName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "capacityPools");
        this.volumeName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "volumes");
        this.bucketName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "buckets");
    }

    @Override
    public Bucket refresh() {
        this.innerObject = (BucketInner)((Object)this.serviceManager.serviceClient().getBuckets().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.bucketName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Bucket refresh(Context context) {
        this.innerObject = (BucketInner)((Object)this.serviceManager.serviceClient().getBuckets().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.bucketName, context).getValue());
        return this;
    }

    @Override
    public Response<BucketGenerateCredentials> generateCredentialsWithResponse(BucketCredentialsExpiry body, Context context) {
        return this.serviceManager.buckets().generateCredentialsWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.bucketName, body, context);
    }

    @Override
    public BucketGenerateCredentials generateCredentials(BucketCredentialsExpiry body) {
        return this.serviceManager.buckets().generateCredentials(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.bucketName, body);
    }

    @Override
    public BucketImpl withPath(String path) {
        if (this.isInCreateMode()) {
            this.innerModel().withPath(path);
            return this;
        }
        this.updateBody.withPath(path);
        return this;
    }

    @Override
    public BucketImpl withFileSystemUser(FileSystemUser fileSystemUser) {
        if (this.isInCreateMode()) {
            this.innerModel().withFileSystemUser(fileSystemUser);
            return this;
        }
        this.updateBody.withFileSystemUser(fileSystemUser);
        return this;
    }

    @Override
    public BucketImpl withServer(BucketServerProperties server) {
        this.innerModel().withServer(server);
        return this;
    }

    @Override
    public BucketImpl withPermissions(BucketPermissions permissions) {
        this.innerModel().withPermissions(permissions);
        return this;
    }

    @Override
    public BucketImpl withServer(BucketServerPatchProperties server) {
        this.updateBody.withServer(server);
        return this;
    }

    @Override
    public BucketImpl withPermissions(BucketPatchPermissions permissions) {
        this.updateBody.withPermissions(permissions);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

