/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.BackupPoliciesClient;
import com.azure.resourcemanager.netapp.fluent.models.BackupPolicyInner;
import com.azure.resourcemanager.netapp.implementation.BackupPolicyImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.BackupPolicies;
import com.azure.resourcemanager.netapp.models.BackupPolicy;

public final class BackupPoliciesImpl
implements BackupPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(BackupPoliciesImpl.class);
    private final BackupPoliciesClient innerClient;
    private final NetAppFilesManager serviceManager;

    public BackupPoliciesImpl(BackupPoliciesClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<BackupPolicy> getWithResponse(String resourceGroupName, String accountName, String backupPolicyName, Context context) {
        Response<BackupPolicyInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, backupPolicyName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BackupPolicyImpl((BackupPolicyInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public BackupPolicy get(String resourceGroupName, String accountName, String backupPolicyName) {
        BackupPolicyInner inner = this.serviceClient().get(resourceGroupName, accountName, backupPolicyName);
        if (inner != null) {
            return new BackupPolicyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String backupPolicyName) {
        this.serviceClient().delete(resourceGroupName, accountName, backupPolicyName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String backupPolicyName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, backupPolicyName, context);
    }

    @Override
    public PagedIterable<BackupPolicy> list(String resourceGroupName, String accountName) {
        PagedIterable<BackupPolicyInner> inner = this.serviceClient().list(resourceGroupName, accountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupPolicyImpl((BackupPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BackupPolicy> list(String resourceGroupName, String accountName, Context context) {
        PagedIterable<BackupPolicyInner> inner = this.serviceClient().list(resourceGroupName, accountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupPolicyImpl((BackupPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public BackupPolicy getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String backupPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "backupPolicies");
        if (backupPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupPolicies'.", id)));
        }
        return (BackupPolicy)this.getWithResponse(resourceGroupName, accountName, backupPolicyName, Context.NONE).getValue();
    }

    @Override
    public Response<BackupPolicy> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String backupPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "backupPolicies");
        if (backupPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupPolicies'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, backupPolicyName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String backupPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "backupPolicies");
        if (backupPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupPolicies'.", id)));
        }
        this.delete(resourceGroupName, accountName, backupPolicyName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String backupPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "backupPolicies");
        if (backupPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupPolicies'.", id)));
        }
        this.delete(resourceGroupName, accountName, backupPolicyName, context);
    }

    private BackupPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public BackupPolicyImpl define(String name) {
        return new BackupPolicyImpl(name, this.manager());
    }
}

