/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.ActiveDirectoryConfigsClient;
import com.azure.resourcemanager.netapp.fluent.models.ActiveDirectoryConfigInner;
import com.azure.resourcemanager.netapp.implementation.ActiveDirectoryConfigImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ActiveDirectoryConfig;
import com.azure.resourcemanager.netapp.models.ActiveDirectoryConfigs;

public final class ActiveDirectoryConfigsImpl
implements ActiveDirectoryConfigs {
    private static final ClientLogger LOGGER = new ClientLogger(ActiveDirectoryConfigsImpl.class);
    private final ActiveDirectoryConfigsClient innerClient;
    private final NetAppFilesManager serviceManager;

    public ActiveDirectoryConfigsImpl(ActiveDirectoryConfigsClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ActiveDirectoryConfig> getByResourceGroupWithResponse(String resourceGroupName, String activeDirectoryConfigName, Context context) {
        Response<ActiveDirectoryConfigInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, activeDirectoryConfigName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ActiveDirectoryConfigImpl((ActiveDirectoryConfigInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ActiveDirectoryConfig getByResourceGroup(String resourceGroupName, String activeDirectoryConfigName) {
        ActiveDirectoryConfigInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, activeDirectoryConfigName);
        if (inner != null) {
            return new ActiveDirectoryConfigImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String activeDirectoryConfigName) {
        this.serviceClient().delete(resourceGroupName, activeDirectoryConfigName);
    }

    @Override
    public void delete(String resourceGroupName, String activeDirectoryConfigName, Context context) {
        this.serviceClient().delete(resourceGroupName, activeDirectoryConfigName, context);
    }

    @Override
    public PagedIterable<ActiveDirectoryConfig> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ActiveDirectoryConfigInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ActiveDirectoryConfigImpl((ActiveDirectoryConfigInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ActiveDirectoryConfig> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ActiveDirectoryConfigInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ActiveDirectoryConfigImpl((ActiveDirectoryConfigInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ActiveDirectoryConfig> list() {
        PagedIterable<ActiveDirectoryConfigInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ActiveDirectoryConfigImpl((ActiveDirectoryConfigInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ActiveDirectoryConfig> list(Context context) {
        PagedIterable<ActiveDirectoryConfigInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ActiveDirectoryConfigImpl((ActiveDirectoryConfigInner)((Object)inner1), this.manager()));
    }

    @Override
    public ActiveDirectoryConfig getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String activeDirectoryConfigName = ResourceManagerUtils.getValueFromIdByName(id, "activeDirectoryConfigs");
        if (activeDirectoryConfigName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'activeDirectoryConfigs'.", id)));
        }
        return (ActiveDirectoryConfig)this.getByResourceGroupWithResponse(resourceGroupName, activeDirectoryConfigName, Context.NONE).getValue();
    }

    @Override
    public Response<ActiveDirectoryConfig> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String activeDirectoryConfigName = ResourceManagerUtils.getValueFromIdByName(id, "activeDirectoryConfigs");
        if (activeDirectoryConfigName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'activeDirectoryConfigs'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, activeDirectoryConfigName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String activeDirectoryConfigName = ResourceManagerUtils.getValueFromIdByName(id, "activeDirectoryConfigs");
        if (activeDirectoryConfigName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'activeDirectoryConfigs'.", id)));
        }
        this.delete(resourceGroupName, activeDirectoryConfigName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String activeDirectoryConfigName = ResourceManagerUtils.getValueFromIdByName(id, "activeDirectoryConfigs");
        if (activeDirectoryConfigName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'activeDirectoryConfigs'.", id)));
        }
        this.delete(resourceGroupName, activeDirectoryConfigName, context);
    }

    private ActiveDirectoryConfigsClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ActiveDirectoryConfigImpl define(String name) {
        return new ActiveDirectoryConfigImpl(name, this.manager());
    }
}

