/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.ActiveDirectoryConfigInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ActiveDirectoryConfig;
import com.azure.resourcemanager.netapp.models.ActiveDirectoryConfigProperties;
import com.azure.resourcemanager.netapp.models.ActiveDirectoryConfigUpdate;
import com.azure.resourcemanager.netapp.models.ActiveDirectoryConfigUpdateProperties;
import com.azure.resourcemanager.netapp.models.ManagedServiceIdentity;
import java.util.Collections;
import java.util.Map;

public final class ActiveDirectoryConfigImpl
implements ActiveDirectoryConfig,
ActiveDirectoryConfig.Definition,
ActiveDirectoryConfig.Update {
    private ActiveDirectoryConfigInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String activeDirectoryConfigName;
    private ActiveDirectoryConfigUpdate updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ActiveDirectoryConfigProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ActiveDirectoryConfigInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ActiveDirectoryConfigImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ActiveDirectoryConfig create() {
        this.innerObject = this.serviceManager.serviceClient().getActiveDirectoryConfigs().createOrUpdate(this.resourceGroupName, this.activeDirectoryConfigName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ActiveDirectoryConfig create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getActiveDirectoryConfigs().createOrUpdate(this.resourceGroupName, this.activeDirectoryConfigName, this.innerModel(), context);
        return this;
    }

    ActiveDirectoryConfigImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new ActiveDirectoryConfigInner();
        this.serviceManager = serviceManager;
        this.activeDirectoryConfigName = name;
    }

    @Override
    public ActiveDirectoryConfigImpl update() {
        this.updateBody = new ActiveDirectoryConfigUpdate();
        return this;
    }

    @Override
    public ActiveDirectoryConfig apply() {
        this.innerObject = this.serviceManager.serviceClient().getActiveDirectoryConfigs().update(this.resourceGroupName, this.activeDirectoryConfigName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public ActiveDirectoryConfig apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getActiveDirectoryConfigs().update(this.resourceGroupName, this.activeDirectoryConfigName, this.updateBody, context);
        return this;
    }

    ActiveDirectoryConfigImpl(ActiveDirectoryConfigInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.activeDirectoryConfigName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "activeDirectoryConfigs");
    }

    @Override
    public ActiveDirectoryConfig refresh() {
        this.innerObject = (ActiveDirectoryConfigInner)((Object)this.serviceManager.serviceClient().getActiveDirectoryConfigs().getByResourceGroupWithResponse(this.resourceGroupName, this.activeDirectoryConfigName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ActiveDirectoryConfig refresh(Context context) {
        this.innerObject = (ActiveDirectoryConfigInner)((Object)this.serviceManager.serviceClient().getActiveDirectoryConfigs().getByResourceGroupWithResponse(this.resourceGroupName, this.activeDirectoryConfigName, context).getValue());
        return this;
    }

    @Override
    public ActiveDirectoryConfigImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ActiveDirectoryConfigImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ActiveDirectoryConfigImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBody.withTags(tags);
        return this;
    }

    @Override
    public ActiveDirectoryConfigImpl withProperties(ActiveDirectoryConfigProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public ActiveDirectoryConfigImpl withIdentity(ManagedServiceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateBody.withIdentity(identity);
        return this;
    }

    @Override
    public ActiveDirectoryConfigImpl withProperties(ActiveDirectoryConfigUpdateProperties properties) {
        this.updateBody.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

