/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.CoolAccessRetrievalPolicy;
import com.azure.resourcemanager.netapp.models.CoolAccessTieringPolicy;
import com.azure.resourcemanager.netapp.models.ServiceLevel;
import com.azure.resourcemanager.netapp.models.SmbAccessBasedEnumeration;
import com.azure.resourcemanager.netapp.models.SmbNonBrowsable;
import com.azure.resourcemanager.netapp.models.VolumePatchPropertiesDataProtection;
import com.azure.resourcemanager.netapp.models.VolumePatchPropertiesExportPolicy;
import java.io.IOException;
import java.util.List;

public final class VolumePatchProperties
implements JsonSerializable<VolumePatchProperties> {
    private ServiceLevel serviceLevel;
    private Long usageThreshold;
    private VolumePatchPropertiesExportPolicy exportPolicy;
    private List<String> protocolTypes;
    private Float throughputMibps;
    private VolumePatchPropertiesDataProtection dataProtection;
    private Boolean isDefaultQuotaEnabled;
    private Long defaultUserQuotaInKiBs;
    private Long defaultGroupQuotaInKiBs;
    private String unixPermissions;
    private Boolean coolAccess;
    private Integer coolnessPeriod;
    private CoolAccessRetrievalPolicy coolAccessRetrievalPolicy;
    private CoolAccessTieringPolicy coolAccessTieringPolicy;
    private Boolean snapshotDirectoryVisible;
    private SmbAccessBasedEnumeration smbAccessBasedEnumeration;
    private SmbNonBrowsable smbNonBrowsable;

    public ServiceLevel serviceLevel() {
        return this.serviceLevel;
    }

    public VolumePatchProperties withServiceLevel(ServiceLevel serviceLevel) {
        this.serviceLevel = serviceLevel;
        return this;
    }

    public Long usageThreshold() {
        return this.usageThreshold;
    }

    public VolumePatchProperties withUsageThreshold(Long usageThreshold) {
        this.usageThreshold = usageThreshold;
        return this;
    }

    public VolumePatchPropertiesExportPolicy exportPolicy() {
        return this.exportPolicy;
    }

    public VolumePatchProperties withExportPolicy(VolumePatchPropertiesExportPolicy exportPolicy) {
        this.exportPolicy = exportPolicy;
        return this;
    }

    public List<String> protocolTypes() {
        return this.protocolTypes;
    }

    public VolumePatchProperties withProtocolTypes(List<String> protocolTypes) {
        this.protocolTypes = protocolTypes;
        return this;
    }

    public Float throughputMibps() {
        return this.throughputMibps;
    }

    public VolumePatchProperties withThroughputMibps(Float throughputMibps) {
        this.throughputMibps = throughputMibps;
        return this;
    }

    public VolumePatchPropertiesDataProtection dataProtection() {
        return this.dataProtection;
    }

    public VolumePatchProperties withDataProtection(VolumePatchPropertiesDataProtection dataProtection) {
        this.dataProtection = dataProtection;
        return this;
    }

    public Boolean isDefaultQuotaEnabled() {
        return this.isDefaultQuotaEnabled;
    }

    public VolumePatchProperties withIsDefaultQuotaEnabled(Boolean isDefaultQuotaEnabled) {
        this.isDefaultQuotaEnabled = isDefaultQuotaEnabled;
        return this;
    }

    public Long defaultUserQuotaInKiBs() {
        return this.defaultUserQuotaInKiBs;
    }

    public VolumePatchProperties withDefaultUserQuotaInKiBs(Long defaultUserQuotaInKiBs) {
        this.defaultUserQuotaInKiBs = defaultUserQuotaInKiBs;
        return this;
    }

    public Long defaultGroupQuotaInKiBs() {
        return this.defaultGroupQuotaInKiBs;
    }

    public VolumePatchProperties withDefaultGroupQuotaInKiBs(Long defaultGroupQuotaInKiBs) {
        this.defaultGroupQuotaInKiBs = defaultGroupQuotaInKiBs;
        return this;
    }

    public String unixPermissions() {
        return this.unixPermissions;
    }

    public VolumePatchProperties withUnixPermissions(String unixPermissions) {
        this.unixPermissions = unixPermissions;
        return this;
    }

    public Boolean coolAccess() {
        return this.coolAccess;
    }

    public VolumePatchProperties withCoolAccess(Boolean coolAccess) {
        this.coolAccess = coolAccess;
        return this;
    }

    public Integer coolnessPeriod() {
        return this.coolnessPeriod;
    }

    public VolumePatchProperties withCoolnessPeriod(Integer coolnessPeriod) {
        this.coolnessPeriod = coolnessPeriod;
        return this;
    }

    public CoolAccessRetrievalPolicy coolAccessRetrievalPolicy() {
        return this.coolAccessRetrievalPolicy;
    }

    public VolumePatchProperties withCoolAccessRetrievalPolicy(CoolAccessRetrievalPolicy coolAccessRetrievalPolicy) {
        this.coolAccessRetrievalPolicy = coolAccessRetrievalPolicy;
        return this;
    }

    public CoolAccessTieringPolicy coolAccessTieringPolicy() {
        return this.coolAccessTieringPolicy;
    }

    public VolumePatchProperties withCoolAccessTieringPolicy(CoolAccessTieringPolicy coolAccessTieringPolicy) {
        this.coolAccessTieringPolicy = coolAccessTieringPolicy;
        return this;
    }

    public Boolean snapshotDirectoryVisible() {
        return this.snapshotDirectoryVisible;
    }

    public VolumePatchProperties withSnapshotDirectoryVisible(Boolean snapshotDirectoryVisible) {
        this.snapshotDirectoryVisible = snapshotDirectoryVisible;
        return this;
    }

    public SmbAccessBasedEnumeration smbAccessBasedEnumeration() {
        return this.smbAccessBasedEnumeration;
    }

    public VolumePatchProperties withSmbAccessBasedEnumeration(SmbAccessBasedEnumeration smbAccessBasedEnumeration) {
        this.smbAccessBasedEnumeration = smbAccessBasedEnumeration;
        return this;
    }

    public SmbNonBrowsable smbNonBrowsable() {
        return this.smbNonBrowsable;
    }

    public VolumePatchProperties withSmbNonBrowsable(SmbNonBrowsable smbNonBrowsable) {
        this.smbNonBrowsable = smbNonBrowsable;
        return this;
    }

    public void validate() {
        if (this.exportPolicy() != null) {
            this.exportPolicy().validate();
        }
        if (this.dataProtection() != null) {
            this.dataProtection().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceLevel", this.serviceLevel == null ? null : this.serviceLevel.toString());
        jsonWriter.writeNumberField("usageThreshold", (Number)this.usageThreshold);
        jsonWriter.writeJsonField("exportPolicy", (JsonSerializable)this.exportPolicy);
        jsonWriter.writeArrayField("protocolTypes", this.protocolTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("throughputMibps", (Number)this.throughputMibps);
        jsonWriter.writeJsonField("dataProtection", (JsonSerializable)this.dataProtection);
        jsonWriter.writeBooleanField("isDefaultQuotaEnabled", this.isDefaultQuotaEnabled);
        jsonWriter.writeNumberField("defaultUserQuotaInKiBs", (Number)this.defaultUserQuotaInKiBs);
        jsonWriter.writeNumberField("defaultGroupQuotaInKiBs", (Number)this.defaultGroupQuotaInKiBs);
        jsonWriter.writeStringField("unixPermissions", this.unixPermissions);
        jsonWriter.writeBooleanField("coolAccess", this.coolAccess);
        jsonWriter.writeNumberField("coolnessPeriod", (Number)this.coolnessPeriod);
        jsonWriter.writeStringField("coolAccessRetrievalPolicy", this.coolAccessRetrievalPolicy == null ? null : this.coolAccessRetrievalPolicy.toString());
        jsonWriter.writeStringField("coolAccessTieringPolicy", this.coolAccessTieringPolicy == null ? null : this.coolAccessTieringPolicy.toString());
        jsonWriter.writeBooleanField("snapshotDirectoryVisible", this.snapshotDirectoryVisible);
        jsonWriter.writeStringField("smbAccessBasedEnumeration", this.smbAccessBasedEnumeration == null ? null : this.smbAccessBasedEnumeration.toString());
        jsonWriter.writeStringField("smbNonBrowsable", this.smbNonBrowsable == null ? null : this.smbNonBrowsable.toString());
        return jsonWriter.writeEndObject();
    }

    public static VolumePatchProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VolumePatchProperties)jsonReader.readObject(reader -> {
            VolumePatchProperties deserializedVolumePatchProperties = new VolumePatchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceLevel".equals(fieldName)) {
                    deserializedVolumePatchProperties.serviceLevel = ServiceLevel.fromString(reader.getString());
                    continue;
                }
                if ("usageThreshold".equals(fieldName)) {
                    deserializedVolumePatchProperties.usageThreshold = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("exportPolicy".equals(fieldName)) {
                    deserializedVolumePatchProperties.exportPolicy = VolumePatchPropertiesExportPolicy.fromJson(reader);
                    continue;
                }
                if ("protocolTypes".equals(fieldName)) {
                    List protocolTypes;
                    deserializedVolumePatchProperties.protocolTypes = protocolTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("throughputMibps".equals(fieldName)) {
                    deserializedVolumePatchProperties.throughputMibps = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("dataProtection".equals(fieldName)) {
                    deserializedVolumePatchProperties.dataProtection = VolumePatchPropertiesDataProtection.fromJson(reader);
                    continue;
                }
                if ("isDefaultQuotaEnabled".equals(fieldName)) {
                    deserializedVolumePatchProperties.isDefaultQuotaEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultUserQuotaInKiBs".equals(fieldName)) {
                    deserializedVolumePatchProperties.defaultUserQuotaInKiBs = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("defaultGroupQuotaInKiBs".equals(fieldName)) {
                    deserializedVolumePatchProperties.defaultGroupQuotaInKiBs = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("unixPermissions".equals(fieldName)) {
                    deserializedVolumePatchProperties.unixPermissions = reader.getString();
                    continue;
                }
                if ("coolAccess".equals(fieldName)) {
                    deserializedVolumePatchProperties.coolAccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("coolnessPeriod".equals(fieldName)) {
                    deserializedVolumePatchProperties.coolnessPeriod = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("coolAccessRetrievalPolicy".equals(fieldName)) {
                    deserializedVolumePatchProperties.coolAccessRetrievalPolicy = CoolAccessRetrievalPolicy.fromString(reader.getString());
                    continue;
                }
                if ("coolAccessTieringPolicy".equals(fieldName)) {
                    deserializedVolumePatchProperties.coolAccessTieringPolicy = CoolAccessTieringPolicy.fromString(reader.getString());
                    continue;
                }
                if ("snapshotDirectoryVisible".equals(fieldName)) {
                    deserializedVolumePatchProperties.snapshotDirectoryVisible = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("smbAccessBasedEnumeration".equals(fieldName)) {
                    deserializedVolumePatchProperties.smbAccessBasedEnumeration = SmbAccessBasedEnumeration.fromString(reader.getString());
                    continue;
                }
                if ("smbNonBrowsable".equals(fieldName)) {
                    deserializedVolumePatchProperties.smbNonBrowsable = SmbNonBrowsable.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumePatchProperties;
        });
    }
}

