/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.MirrorState;
import com.azure.resourcemanager.netapp.models.VolumeReplicationRelationshipStatus;
import java.io.IOException;

public final class ReplicationStatusInner
implements JsonSerializable<ReplicationStatusInner> {
    private Boolean healthy;
    private VolumeReplicationRelationshipStatus relationshipStatus;
    private MirrorState mirrorState;
    private String totalProgress;
    private String errorMessage;

    private ReplicationStatusInner() {
    }

    public Boolean healthy() {
        return this.healthy;
    }

    public VolumeReplicationRelationshipStatus relationshipStatus() {
        return this.relationshipStatus;
    }

    public MirrorState mirrorState() {
        return this.mirrorState;
    }

    public String totalProgress() {
        return this.totalProgress;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("healthy", this.healthy);
        jsonWriter.writeStringField("relationshipStatus", this.relationshipStatus == null ? null : this.relationshipStatus.toString());
        jsonWriter.writeStringField("mirrorState", this.mirrorState == null ? null : this.mirrorState.toString());
        jsonWriter.writeStringField("totalProgress", this.totalProgress);
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        return jsonWriter.writeEndObject();
    }

    public static ReplicationStatusInner fromJson(JsonReader jsonReader) throws IOException {
        return (ReplicationStatusInner)jsonReader.readObject(reader -> {
            ReplicationStatusInner deserializedReplicationStatusInner = new ReplicationStatusInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("healthy".equals(fieldName)) {
                    deserializedReplicationStatusInner.healthy = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("relationshipStatus".equals(fieldName)) {
                    deserializedReplicationStatusInner.relationshipStatus = VolumeReplicationRelationshipStatus.fromString(reader.getString());
                    continue;
                }
                if ("mirrorState".equals(fieldName)) {
                    deserializedReplicationStatusInner.mirrorState = MirrorState.fromString(reader.getString());
                    continue;
                }
                if ("totalProgress".equals(fieldName)) {
                    deserializedReplicationStatusInner.totalProgress = reader.getString();
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedReplicationStatusInner.errorMessage = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReplicationStatusInner;
        });
    }
}

