/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.AccountProperties;
import com.azure.resourcemanager.netapp.models.AccountEncryption;
import com.azure.resourcemanager.netapp.models.ActiveDirectory;
import com.azure.resourcemanager.netapp.models.LdapConfiguration;
import com.azure.resourcemanager.netapp.models.ManagedServiceIdentity;
import com.azure.resourcemanager.netapp.models.MultiAdStatus;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class NetAppAccountInner
extends Resource {
    private AccountProperties innerProperties;
    private String etag;
    private ManagedServiceIdentity identity;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private AccountProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public NetAppAccountInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public NetAppAccountInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public NetAppAccountInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<ActiveDirectory> activeDirectories() {
        return this.innerProperties() == null ? null : this.innerProperties().activeDirectories();
    }

    public NetAppAccountInner withActiveDirectories(List<ActiveDirectory> activeDirectories) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AccountProperties();
        }
        this.innerProperties().withActiveDirectories(activeDirectories);
        return this;
    }

    public AccountEncryption encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public NetAppAccountInner withEncryption(AccountEncryption encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AccountProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public Boolean disableShowmount() {
        return this.innerProperties() == null ? null : this.innerProperties().disableShowmount();
    }

    public String nfsV4IdDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().nfsV4IdDomain();
    }

    public NetAppAccountInner withNfsV4IdDomain(String nfsV4IdDomain) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AccountProperties();
        }
        this.innerProperties().withNfsV4IdDomain(nfsV4IdDomain);
        return this;
    }

    public MultiAdStatus multiAdStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().multiAdStatus();
    }

    public LdapConfiguration ldapConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().ldapConfiguration();
    }

    public NetAppAccountInner withLdapConfiguration(LdapConfiguration ldapConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AccountProperties();
        }
        this.innerProperties().withLdapConfiguration(ldapConfiguration);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static NetAppAccountInner fromJson(JsonReader jsonReader) throws IOException {
        return (NetAppAccountInner)((Object)jsonReader.readObject(reader -> {
            NetAppAccountInner deserializedNetAppAccountInner = new NetAppAccountInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNetAppAccountInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNetAppAccountInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNetAppAccountInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedNetAppAccountInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedNetAppAccountInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNetAppAccountInner.innerProperties = AccountProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedNetAppAccountInner.etag = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedNetAppAccountInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedNetAppAccountInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetAppAccountInner;
        }));
    }
}

