/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticCapacityPoolProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ElasticCapacityPoolInner
extends Resource {
    private ElasticCapacityPoolProperties properties;
    private String eTag;
    private List<String> zones;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ElasticCapacityPoolProperties properties() {
        return this.properties;
    }

    public ElasticCapacityPoolInner withProperties(ElasticCapacityPoolProperties properties) {
        this.properties = properties;
        return this;
    }

    public String eTag() {
        return this.eTag;
    }

    public List<String> zones() {
        return this.zones;
    }

    public ElasticCapacityPoolInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ElasticCapacityPoolInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ElasticCapacityPoolInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ElasticCapacityPoolInner fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticCapacityPoolInner)((Object)jsonReader.readObject(reader -> {
            ElasticCapacityPoolInner deserializedElasticCapacityPoolInner = new ElasticCapacityPoolInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedElasticCapacityPoolInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedElasticCapacityPoolInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedElasticCapacityPoolInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedElasticCapacityPoolInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedElasticCapacityPoolInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedElasticCapacityPoolInner.properties = ElasticCapacityPoolProperties.fromJson(reader);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedElasticCapacityPoolInner.eTag = reader.getString();
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedElasticCapacityPoolInner.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedElasticCapacityPoolInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticCapacityPoolInner;
        }));
    }
}

