/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticBackupVaultProperties;
import java.io.IOException;
import java.util.Map;

public final class ElasticBackupVaultInner
extends Resource {
    private ElasticBackupVaultProperties properties;
    private String eTag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ElasticBackupVaultProperties properties() {
        return this.properties;
    }

    public ElasticBackupVaultInner withProperties(ElasticBackupVaultProperties properties) {
        this.properties = properties;
        return this;
    }

    public String eTag() {
        return this.eTag;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ElasticBackupVaultInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ElasticBackupVaultInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ElasticBackupVaultInner fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticBackupVaultInner)((Object)jsonReader.readObject(reader -> {
            ElasticBackupVaultInner deserializedElasticBackupVaultInner = new ElasticBackupVaultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedElasticBackupVaultInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedElasticBackupVaultInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedElasticBackupVaultInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedElasticBackupVaultInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedElasticBackupVaultInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedElasticBackupVaultInner.properties = ElasticBackupVaultProperties.fromJson(reader);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedElasticBackupVaultInner.eTag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedElasticBackupVaultInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticBackupVaultInner;
        }));
    }
}

