/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticBackupPolicyProperties;
import java.io.IOException;
import java.util.Map;

public final class ElasticBackupPolicyInner
extends Resource {
    private ElasticBackupPolicyProperties properties;
    private String eTag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ElasticBackupPolicyProperties properties() {
        return this.properties;
    }

    public ElasticBackupPolicyInner withProperties(ElasticBackupPolicyProperties properties) {
        this.properties = properties;
        return this;
    }

    public String eTag() {
        return this.eTag;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ElasticBackupPolicyInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ElasticBackupPolicyInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ElasticBackupPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticBackupPolicyInner)((Object)jsonReader.readObject(reader -> {
            ElasticBackupPolicyInner deserializedElasticBackupPolicyInner = new ElasticBackupPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedElasticBackupPolicyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedElasticBackupPolicyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedElasticBackupPolicyInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedElasticBackupPolicyInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedElasticBackupPolicyInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedElasticBackupPolicyInner.properties = ElasticBackupPolicyProperties.fromJson(reader);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedElasticBackupPolicyInner.eTag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedElasticBackupPolicyInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticBackupPolicyInner;
        }));
    }
}

