/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticAccountProperties;
import com.azure.resourcemanager.netapp.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.Map;

public final class ElasticAccountInner
extends Resource {
    private ElasticAccountProperties properties;
    private String eTag;
    private ManagedServiceIdentity identity;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ElasticAccountProperties properties() {
        return this.properties;
    }

    public ElasticAccountInner withProperties(ElasticAccountProperties properties) {
        this.properties = properties;
        return this;
    }

    public String eTag() {
        return this.eTag;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ElasticAccountInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ElasticAccountInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ElasticAccountInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static ElasticAccountInner fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticAccountInner)((Object)jsonReader.readObject(reader -> {
            ElasticAccountInner deserializedElasticAccountInner = new ElasticAccountInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedElasticAccountInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedElasticAccountInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedElasticAccountInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedElasticAccountInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedElasticAccountInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedElasticAccountInner.properties = ElasticAccountProperties.fromJson(reader);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedElasticAccountInner.eTag = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedElasticAccountInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedElasticAccountInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticAccountInner;
        }));
    }
}

