/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.PoolProperties;
import com.azure.resourcemanager.netapp.models.EncryptionType;
import com.azure.resourcemanager.netapp.models.QosType;
import com.azure.resourcemanager.netapp.models.ServiceLevel;
import java.io.IOException;
import java.util.Map;

public final class CapacityPoolInner
extends Resource {
    private PoolProperties innerProperties = new PoolProperties();
    private String etag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(CapacityPoolInner.class);

    private PoolProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public CapacityPoolInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public CapacityPoolInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String poolId() {
        return this.innerProperties() == null ? null : this.innerProperties().poolId();
    }

    public long size() {
        return this.innerProperties() == null ? 0L : this.innerProperties().size();
    }

    public CapacityPoolInner withSize(long size) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withSize(size);
        return this;
    }

    public ServiceLevel serviceLevel() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceLevel();
    }

    public CapacityPoolInner withServiceLevel(ServiceLevel serviceLevel) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withServiceLevel(serviceLevel);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Float totalThroughputMibps() {
        return this.innerProperties() == null ? null : this.innerProperties().totalThroughputMibps();
    }

    public Float utilizedThroughputMibps() {
        return this.innerProperties() == null ? null : this.innerProperties().utilizedThroughputMibps();
    }

    public Integer customThroughputMibps() {
        return this.innerProperties() == null ? null : this.innerProperties().customThroughputMibps();
    }

    public CapacityPoolInner withCustomThroughputMibps(Integer customThroughputMibps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withCustomThroughputMibps(customThroughputMibps);
        return this;
    }

    public QosType qosType() {
        return this.innerProperties() == null ? null : this.innerProperties().qosType();
    }

    public CapacityPoolInner withQosType(QosType qosType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withQosType(qosType);
        return this;
    }

    public Boolean coolAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().coolAccess();
    }

    public CapacityPoolInner withCoolAccess(Boolean coolAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withCoolAccess(coolAccess);
        return this;
    }

    public EncryptionType encryptionType() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionType();
    }

    public CapacityPoolInner withEncryptionType(EncryptionType encryptionType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withEncryptionType(encryptionType);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model CapacityPoolInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CapacityPoolInner fromJson(JsonReader jsonReader) throws IOException {
        return (CapacityPoolInner)((Object)jsonReader.readObject(reader -> {
            CapacityPoolInner deserializedCapacityPoolInner = new CapacityPoolInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCapacityPoolInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCapacityPoolInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCapacityPoolInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCapacityPoolInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCapacityPoolInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCapacityPoolInner.innerProperties = PoolProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedCapacityPoolInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedCapacityPoolInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCapacityPoolInner;
        }));
    }
}

