/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.BucketPermissions;
import com.azure.resourcemanager.netapp.models.BucketServerProperties;
import com.azure.resourcemanager.netapp.models.CredentialsStatus;
import com.azure.resourcemanager.netapp.models.FileSystemUser;
import com.azure.resourcemanager.netapp.models.ProvisioningState;
import java.io.IOException;

public final class BucketProperties
implements JsonSerializable<BucketProperties> {
    private String path;
    private FileSystemUser fileSystemUser;
    private ProvisioningState provisioningState;
    private CredentialsStatus status;
    private BucketServerProperties server;
    private BucketPermissions permissions;

    public String path() {
        return this.path;
    }

    public BucketProperties withPath(String path) {
        this.path = path;
        return this;
    }

    public FileSystemUser fileSystemUser() {
        return this.fileSystemUser;
    }

    public BucketProperties withFileSystemUser(FileSystemUser fileSystemUser) {
        this.fileSystemUser = fileSystemUser;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public CredentialsStatus status() {
        return this.status;
    }

    public BucketServerProperties server() {
        return this.server;
    }

    public BucketProperties withServer(BucketServerProperties server) {
        this.server = server;
        return this;
    }

    public BucketPermissions permissions() {
        return this.permissions;
    }

    public BucketProperties withPermissions(BucketPermissions permissions) {
        this.permissions = permissions;
        return this;
    }

    public void validate() {
        if (this.fileSystemUser() != null) {
            this.fileSystemUser().validate();
        }
        if (this.server() != null) {
            this.server().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeJsonField("fileSystemUser", (JsonSerializable)this.fileSystemUser);
        jsonWriter.writeJsonField("server", (JsonSerializable)this.server);
        jsonWriter.writeStringField("permissions", this.permissions == null ? null : this.permissions.toString());
        return jsonWriter.writeEndObject();
    }

    public static BucketProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BucketProperties)jsonReader.readObject(reader -> {
            BucketProperties deserializedBucketProperties = new BucketProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("path".equals(fieldName)) {
                    deserializedBucketProperties.path = reader.getString();
                    continue;
                }
                if ("fileSystemUser".equals(fieldName)) {
                    deserializedBucketProperties.fileSystemUser = FileSystemUser.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBucketProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedBucketProperties.status = CredentialsStatus.fromString(reader.getString());
                    continue;
                }
                if ("server".equals(fieldName)) {
                    deserializedBucketProperties.server = BucketServerProperties.fromJson(reader);
                    continue;
                }
                if ("permissions".equals(fieldName)) {
                    deserializedBucketProperties.permissions = BucketPermissions.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBucketProperties;
        });
    }
}

