/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.BucketPatchPermissions;
import com.azure.resourcemanager.netapp.models.BucketServerPatchProperties;
import com.azure.resourcemanager.netapp.models.FileSystemUser;
import com.azure.resourcemanager.netapp.models.ProvisioningState;
import java.io.IOException;

public final class BucketPatchProperties
implements JsonSerializable<BucketPatchProperties> {
    private String path;
    private FileSystemUser fileSystemUser;
    private ProvisioningState provisioningState;
    private BucketServerPatchProperties server;
    private BucketPatchPermissions permissions;

    public String path() {
        return this.path;
    }

    public BucketPatchProperties withPath(String path) {
        this.path = path;
        return this;
    }

    public FileSystemUser fileSystemUser() {
        return this.fileSystemUser;
    }

    public BucketPatchProperties withFileSystemUser(FileSystemUser fileSystemUser) {
        this.fileSystemUser = fileSystemUser;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public BucketServerPatchProperties server() {
        return this.server;
    }

    public BucketPatchProperties withServer(BucketServerPatchProperties server) {
        this.server = server;
        return this;
    }

    public BucketPatchPermissions permissions() {
        return this.permissions;
    }

    public BucketPatchProperties withPermissions(BucketPatchPermissions permissions) {
        this.permissions = permissions;
        return this;
    }

    public void validate() {
        if (this.fileSystemUser() != null) {
            this.fileSystemUser().validate();
        }
        if (this.server() != null) {
            this.server().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeJsonField("fileSystemUser", (JsonSerializable)this.fileSystemUser);
        jsonWriter.writeJsonField("server", (JsonSerializable)this.server);
        jsonWriter.writeStringField("permissions", this.permissions == null ? null : this.permissions.toString());
        return jsonWriter.writeEndObject();
    }

    public static BucketPatchProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BucketPatchProperties)jsonReader.readObject(reader -> {
            BucketPatchProperties deserializedBucketPatchProperties = new BucketPatchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("path".equals(fieldName)) {
                    deserializedBucketPatchProperties.path = reader.getString();
                    continue;
                }
                if ("fileSystemUser".equals(fieldName)) {
                    deserializedBucketPatchProperties.fileSystemUser = FileSystemUser.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBucketPatchProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("server".equals(fieldName)) {
                    deserializedBucketPatchProperties.server = BucketServerPatchProperties.fromJson(reader);
                    continue;
                }
                if ("permissions".equals(fieldName)) {
                    deserializedBucketPatchProperties.permissions = BucketPatchPermissions.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBucketPatchProperties;
        });
    }
}

