/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.BucketProperties;
import com.azure.resourcemanager.netapp.models.BucketPermissions;
import com.azure.resourcemanager.netapp.models.BucketServerProperties;
import com.azure.resourcemanager.netapp.models.CredentialsStatus;
import com.azure.resourcemanager.netapp.models.FileSystemUser;
import com.azure.resourcemanager.netapp.models.ProvisioningState;
import java.io.IOException;

public final class BucketInner
extends ProxyResource {
    private BucketProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private BucketProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String path() {
        return this.innerProperties() == null ? null : this.innerProperties().path();
    }

    public BucketInner withPath(String path) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BucketProperties();
        }
        this.innerProperties().withPath(path);
        return this;
    }

    public FileSystemUser fileSystemUser() {
        return this.innerProperties() == null ? null : this.innerProperties().fileSystemUser();
    }

    public BucketInner withFileSystemUser(FileSystemUser fileSystemUser) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BucketProperties();
        }
        this.innerProperties().withFileSystemUser(fileSystemUser);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public CredentialsStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public BucketServerProperties server() {
        return this.innerProperties() == null ? null : this.innerProperties().server();
    }

    public BucketInner withServer(BucketServerProperties server) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BucketProperties();
        }
        this.innerProperties().withServer(server);
        return this;
    }

    public BucketPermissions permissions() {
        return this.innerProperties() == null ? null : this.innerProperties().permissions();
    }

    public BucketInner withPermissions(BucketPermissions permissions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BucketProperties();
        }
        this.innerProperties().withPermissions(permissions);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static BucketInner fromJson(JsonReader jsonReader) throws IOException {
        return (BucketInner)((Object)jsonReader.readObject(reader -> {
            BucketInner deserializedBucketInner = new BucketInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBucketInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBucketInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBucketInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBucketInner.innerProperties = BucketProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedBucketInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBucketInner;
        }));
    }
}

