/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.AccountEncryption;
import com.azure.resourcemanager.netapp.models.ActiveDirectory;
import com.azure.resourcemanager.netapp.models.LdapConfiguration;
import com.azure.resourcemanager.netapp.models.MultiAdStatus;
import java.io.IOException;
import java.util.List;

public final class AccountProperties
implements JsonSerializable<AccountProperties> {
    private String provisioningState;
    private List<ActiveDirectory> activeDirectories;
    private AccountEncryption encryption;
    private Boolean disableShowmount;
    private String nfsV4IdDomain;
    private MultiAdStatus multiAdStatus;
    private LdapConfiguration ldapConfiguration;

    public String provisioningState() {
        return this.provisioningState;
    }

    public List<ActiveDirectory> activeDirectories() {
        return this.activeDirectories;
    }

    public AccountProperties withActiveDirectories(List<ActiveDirectory> activeDirectories) {
        this.activeDirectories = activeDirectories;
        return this;
    }

    public AccountEncryption encryption() {
        return this.encryption;
    }

    public AccountProperties withEncryption(AccountEncryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public Boolean disableShowmount() {
        return this.disableShowmount;
    }

    public String nfsV4IdDomain() {
        return this.nfsV4IdDomain;
    }

    public AccountProperties withNfsV4IdDomain(String nfsV4IdDomain) {
        this.nfsV4IdDomain = nfsV4IdDomain;
        return this;
    }

    public MultiAdStatus multiAdStatus() {
        return this.multiAdStatus;
    }

    public LdapConfiguration ldapConfiguration() {
        return this.ldapConfiguration;
    }

    public AccountProperties withLdapConfiguration(LdapConfiguration ldapConfiguration) {
        this.ldapConfiguration = ldapConfiguration;
        return this;
    }

    public void validate() {
        if (this.activeDirectories() != null) {
            this.activeDirectories().forEach(e -> e.validate());
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.ldapConfiguration() != null) {
            this.ldapConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("activeDirectories", this.activeDirectories, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeStringField("nfsV4IDDomain", this.nfsV4IdDomain);
        jsonWriter.writeJsonField("ldapConfiguration", (JsonSerializable)this.ldapConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static AccountProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AccountProperties)jsonReader.readObject(reader -> {
            AccountProperties deserializedAccountProperties = new AccountProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedAccountProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("activeDirectories".equals(fieldName)) {
                    List activeDirectories;
                    deserializedAccountProperties.activeDirectories = activeDirectories = reader.readArray(reader1 -> ActiveDirectory.fromJson(reader1));
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedAccountProperties.encryption = AccountEncryption.fromJson(reader);
                    continue;
                }
                if ("disableShowmount".equals(fieldName)) {
                    deserializedAccountProperties.disableShowmount = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("nfsV4IDDomain".equals(fieldName)) {
                    deserializedAccountProperties.nfsV4IdDomain = reader.getString();
                    continue;
                }
                if ("multiAdStatus".equals(fieldName)) {
                    deserializedAccountProperties.multiAdStatus = MultiAdStatus.fromString(reader.getString());
                    continue;
                }
                if ("ldapConfiguration".equals(fieldName)) {
                    deserializedAccountProperties.ldapConfiguration = LdapConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccountProperties;
        });
    }
}

