/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.CheckQuotaNameResourceTypes;
import java.io.IOException;

public final class QuotaAvailabilityRequest
implements JsonSerializable<QuotaAvailabilityRequest> {
    private String name;
    private CheckQuotaNameResourceTypes type;
    private String resourceGroup;
    private static final ClientLogger LOGGER = new ClientLogger(QuotaAvailabilityRequest.class);

    public String name() {
        return this.name;
    }

    public QuotaAvailabilityRequest withName(String name) {
        this.name = name;
        return this;
    }

    public CheckQuotaNameResourceTypes type() {
        return this.type;
    }

    public QuotaAvailabilityRequest withType(CheckQuotaNameResourceTypes type) {
        this.type = type;
        return this;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public QuotaAvailabilityRequest withResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model QuotaAvailabilityRequest"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model QuotaAvailabilityRequest"));
        }
        if (this.resourceGroup() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceGroup in model QuotaAvailabilityRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("resourceGroup", this.resourceGroup);
        return jsonWriter.writeEndObject();
    }

    public static QuotaAvailabilityRequest fromJson(JsonReader jsonReader) throws IOException {
        return (QuotaAvailabilityRequest)jsonReader.readObject(reader -> {
            QuotaAvailabilityRequest deserializedQuotaAvailabilityRequest = new QuotaAvailabilityRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedQuotaAvailabilityRequest.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedQuotaAvailabilityRequest.type = CheckQuotaNameResourceTypes.fromString(reader.getString());
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedQuotaAvailabilityRequest.resourceGroup = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQuotaAvailabilityRequest;
        });
    }
}

