/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.AccountProperties;
import com.azure.resourcemanager.netapp.models.AccountEncryption;
import com.azure.resourcemanager.netapp.models.ActiveDirectory;
import com.azure.resourcemanager.netapp.models.ManagedServiceIdentity;
import com.azure.resourcemanager.netapp.models.MultiAdStatus;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class NetAppAccountPatch
implements JsonSerializable<NetAppAccountPatch> {
    private String location;
    private String id;
    private String name;
    private String type;
    private Map<String, String> tags;
    private AccountProperties innerProperties;
    private ManagedServiceIdentity identity;

    public String location() {
        return this.location;
    }

    public NetAppAccountPatch withLocation(String location) {
        this.location = location;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public NetAppAccountPatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private AccountProperties innerProperties() {
        return this.innerProperties;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public NetAppAccountPatch withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<ActiveDirectory> activeDirectories() {
        return this.innerProperties() == null ? null : this.innerProperties().activeDirectories();
    }

    public NetAppAccountPatch withActiveDirectories(List<ActiveDirectory> activeDirectories) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AccountProperties();
        }
        this.innerProperties().withActiveDirectories(activeDirectories);
        return this;
    }

    public AccountEncryption encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public NetAppAccountPatch withEncryption(AccountEncryption encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AccountProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public Boolean disableShowmount() {
        return this.innerProperties() == null ? null : this.innerProperties().disableShowmount();
    }

    public String nfsV4IdDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().nfsV4IdDomain();
    }

    public NetAppAccountPatch withNfsV4IdDomain(String nfsV4IdDomain) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AccountProperties();
        }
        this.innerProperties().withNfsV4IdDomain(nfsV4IdDomain);
        return this;
    }

    public MultiAdStatus multiAdStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().multiAdStatus();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static NetAppAccountPatch fromJson(JsonReader jsonReader) throws IOException {
        return (NetAppAccountPatch)jsonReader.readObject(reader -> {
            NetAppAccountPatch deserializedNetAppAccountPatch = new NetAppAccountPatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedNetAppAccountPatch.location = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedNetAppAccountPatch.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNetAppAccountPatch.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNetAppAccountPatch.type = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedNetAppAccountPatch.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNetAppAccountPatch.innerProperties = AccountProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedNetAppAccountPatch.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetAppAccountPatch;
        });
    }
}

