/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.BackupPolicyProperties;
import com.azure.resourcemanager.netapp.models.VolumeBackups;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class BackupPolicyPatch
implements JsonSerializable<BackupPolicyPatch> {
    private String location;
    private String id;
    private String name;
    private String type;
    private Map<String, String> tags;
    private BackupPolicyProperties innerProperties;

    public String location() {
        return this.location;
    }

    public BackupPolicyPatch withLocation(String location) {
        this.location = location;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public BackupPolicyPatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private BackupPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    public String backupPolicyId() {
        return this.innerProperties() == null ? null : this.innerProperties().backupPolicyId();
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Integer dailyBackupsToKeep() {
        return this.innerProperties() == null ? null : this.innerProperties().dailyBackupsToKeep();
    }

    public BackupPolicyPatch withDailyBackupsToKeep(Integer dailyBackupsToKeep) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupPolicyProperties();
        }
        this.innerProperties().withDailyBackupsToKeep(dailyBackupsToKeep);
        return this;
    }

    public Integer weeklyBackupsToKeep() {
        return this.innerProperties() == null ? null : this.innerProperties().weeklyBackupsToKeep();
    }

    public BackupPolicyPatch withWeeklyBackupsToKeep(Integer weeklyBackupsToKeep) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupPolicyProperties();
        }
        this.innerProperties().withWeeklyBackupsToKeep(weeklyBackupsToKeep);
        return this;
    }

    public Integer monthlyBackupsToKeep() {
        return this.innerProperties() == null ? null : this.innerProperties().monthlyBackupsToKeep();
    }

    public BackupPolicyPatch withMonthlyBackupsToKeep(Integer monthlyBackupsToKeep) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupPolicyProperties();
        }
        this.innerProperties().withMonthlyBackupsToKeep(monthlyBackupsToKeep);
        return this;
    }

    public Integer volumesAssigned() {
        return this.innerProperties() == null ? null : this.innerProperties().volumesAssigned();
    }

    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    public BackupPolicyPatch withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupPolicyProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public List<VolumeBackups> volumeBackups() {
        return this.innerProperties() == null ? null : this.innerProperties().volumeBackups();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static BackupPolicyPatch fromJson(JsonReader jsonReader) throws IOException {
        return (BackupPolicyPatch)jsonReader.readObject(reader -> {
            BackupPolicyPatch deserializedBackupPolicyPatch = new BackupPolicyPatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedBackupPolicyPatch.location = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedBackupPolicyPatch.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBackupPolicyPatch.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBackupPolicyPatch.type = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedBackupPolicyPatch.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBackupPolicyPatch.innerProperties = BackupPolicyProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupPolicyPatch;
        });
    }
}

