/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.fluent.models.BackupPolicyInner;
import com.azure.resourcemanager.netapp.models.VolumeBackups;
import java.util.List;
import java.util.Map;

public interface BackupPolicy {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public SystemData systemData();

    public String backupPolicyId();

    public String provisioningState();

    public Integer dailyBackupsToKeep();

    public Integer weeklyBackupsToKeep();

    public Integer monthlyBackupsToKeep();

    public Integer volumesAssigned();

    public Boolean enabled();

    public List<VolumeBackups> volumeBackups();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public BackupPolicyInner innerModel();

    public Update update();

    public BackupPolicy refresh();

    public BackupPolicy refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithEnabled {
            public Update withEnabled(Boolean var1);
        }

        public static interface WithMonthlyBackupsToKeep {
            public Update withMonthlyBackupsToKeep(Integer var1);
        }

        public static interface WithWeeklyBackupsToKeep {
            public Update withWeeklyBackupsToKeep(Integer var1);
        }

        public static interface WithDailyBackupsToKeep {
            public Update withDailyBackupsToKeep(Integer var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithDailyBackupsToKeep,
    UpdateStages.WithWeeklyBackupsToKeep,
    UpdateStages.WithMonthlyBackupsToKeep,
    UpdateStages.WithEnabled {
        public BackupPolicy apply();

        public BackupPolicy apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithEnabled {
            public WithCreate withEnabled(Boolean var1);
        }

        public static interface WithMonthlyBackupsToKeep {
            public WithCreate withMonthlyBackupsToKeep(Integer var1);
        }

        public static interface WithWeeklyBackupsToKeep {
            public WithCreate withWeeklyBackupsToKeep(Integer var1);
        }

        public static interface WithDailyBackupsToKeep {
            public WithCreate withDailyBackupsToKeep(Integer var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithDailyBackupsToKeep,
        WithWeeklyBackupsToKeep,
        WithMonthlyBackupsToKeep,
        WithEnabled {
            public BackupPolicy create();

            public BackupPolicy create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingNetAppAccount(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

