/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.fluent.models.BackupInner;
import com.azure.resourcemanager.netapp.models.BackupType;
import java.time.OffsetDateTime;

public interface Backup {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public String backupId();

    public OffsetDateTime creationDate();

    public OffsetDateTime snapshotCreationDate();

    public OffsetDateTime completionDate();

    public String provisioningState();

    public Long size();

    public String label();

    public BackupType backupType();

    public String failureReason();

    public String volumeResourceId();

    public Boolean useExistingSnapshot();

    public String snapshotName();

    public String backupPolicyResourceId();

    public Boolean isLargeVolume();

    public String resourceGroupName();

    public BackupInner innerModel();

    public Update update();

    public Backup refresh();

    public Backup refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithLabel {
            public Update withLabel(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithLabel {
        public Backup apply();

        public Backup apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithSnapshotName {
            public WithCreate withSnapshotName(String var1);
        }

        public static interface WithUseExistingSnapshot {
            public WithCreate withUseExistingSnapshot(Boolean var1);
        }

        public static interface WithLabel {
            public WithCreate withLabel(String var1);
        }

        public static interface WithCreate
        extends WithLabel,
        WithUseExistingSnapshot,
        WithSnapshotName {
            public Backup create();

            public Backup create(Context var1);
        }

        public static interface WithVolumeResourceId {
            public WithCreate withVolumeResourceId(String var1);
        }

        public static interface WithParentResource {
            public WithVolumeResourceId withExistingBackupVault(String var1, String var2, String var3);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithVolumeResourceId,
    DefinitionStages.WithCreate {
    }
}

