/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.VolumesClient;
import com.azure.resourcemanager.netapp.fluent.models.ClusterPeerCommandResponseInner;
import com.azure.resourcemanager.netapp.fluent.models.GetGroupIdListForLdapUserResponseInner;
import com.azure.resourcemanager.netapp.fluent.models.ReplicationInner;
import com.azure.resourcemanager.netapp.fluent.models.ReplicationStatusInner;
import com.azure.resourcemanager.netapp.fluent.models.SvmPeerCommandResponseInner;
import com.azure.resourcemanager.netapp.fluent.models.VolumeInner;
import com.azure.resourcemanager.netapp.implementation.ClusterPeerCommandResponseImpl;
import com.azure.resourcemanager.netapp.implementation.GetGroupIdListForLdapUserResponseImpl;
import com.azure.resourcemanager.netapp.implementation.ReplicationImpl;
import com.azure.resourcemanager.netapp.implementation.ReplicationStatusImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.implementation.SvmPeerCommandResponseImpl;
import com.azure.resourcemanager.netapp.implementation.VolumeImpl;
import com.azure.resourcemanager.netapp.models.AuthorizeRequest;
import com.azure.resourcemanager.netapp.models.BreakFileLocksRequest;
import com.azure.resourcemanager.netapp.models.BreakReplicationRequest;
import com.azure.resourcemanager.netapp.models.ClusterPeerCommandResponse;
import com.azure.resourcemanager.netapp.models.GetGroupIdListForLdapUserRequest;
import com.azure.resourcemanager.netapp.models.GetGroupIdListForLdapUserResponse;
import com.azure.resourcemanager.netapp.models.ListReplicationsRequest;
import com.azure.resourcemanager.netapp.models.PeerClusterForVolumeMigrationRequest;
import com.azure.resourcemanager.netapp.models.PoolChangeRequest;
import com.azure.resourcemanager.netapp.models.ReestablishReplicationRequest;
import com.azure.resourcemanager.netapp.models.RelocateVolumeRequest;
import com.azure.resourcemanager.netapp.models.Replication;
import com.azure.resourcemanager.netapp.models.ReplicationStatus;
import com.azure.resourcemanager.netapp.models.SvmPeerCommandResponse;
import com.azure.resourcemanager.netapp.models.Volume;
import com.azure.resourcemanager.netapp.models.VolumeRevert;
import com.azure.resourcemanager.netapp.models.Volumes;

public final class VolumesImpl
implements Volumes {
    private static final ClientLogger LOGGER = new ClientLogger(VolumesImpl.class);
    private final VolumesClient innerClient;
    private final NetAppFilesManager serviceManager;

    public VolumesImpl(VolumesClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Volume> getWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        Response<VolumeInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, poolName, volumeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VolumeImpl((VolumeInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Volume get(String resourceGroupName, String accountName, String poolName, String volumeName) {
        VolumeInner inner = this.serviceClient().get(resourceGroupName, accountName, poolName, volumeName);
        if (inner != null) {
            return new VolumeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, volumeName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, Boolean forceDelete, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, volumeName, forceDelete, context);
    }

    @Override
    public PagedIterable<Volume> list(String resourceGroupName, String accountName, String poolName) {
        PagedIterable<VolumeInner> inner = this.serviceClient().list(resourceGroupName, accountName, poolName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VolumeImpl((VolumeInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Volume> list(String resourceGroupName, String accountName, String poolName, Context context) {
        PagedIterable<VolumeInner> inner = this.serviceClient().list(resourceGroupName, accountName, poolName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VolumeImpl((VolumeInner)((Object)inner1), this.manager()));
    }

    @Override
    public Volume populateAvailabilityZone(String resourceGroupName, String accountName, String poolName, String volumeName) {
        VolumeInner inner = this.serviceClient().populateAvailabilityZone(resourceGroupName, accountName, poolName, volumeName);
        if (inner != null) {
            return new VolumeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Volume populateAvailabilityZone(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        VolumeInner inner = this.serviceClient().populateAvailabilityZone(resourceGroupName, accountName, poolName, volumeName, context);
        if (inner != null) {
            return new VolumeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void revert(String resourceGroupName, String accountName, String poolName, String volumeName, VolumeRevert body) {
        this.serviceClient().revert(resourceGroupName, accountName, poolName, volumeName, body);
    }

    @Override
    public void revert(String resourceGroupName, String accountName, String poolName, String volumeName, VolumeRevert body, Context context) {
        this.serviceClient().revert(resourceGroupName, accountName, poolName, volumeName, body, context);
    }

    @Override
    public void resetCifsPassword(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.serviceClient().resetCifsPassword(resourceGroupName, accountName, poolName, volumeName);
    }

    @Override
    public void resetCifsPassword(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        this.serviceClient().resetCifsPassword(resourceGroupName, accountName, poolName, volumeName, context);
    }

    @Override
    public Volume splitCloneFromParent(String resourceGroupName, String accountName, String poolName, String volumeName) {
        VolumeInner inner = this.serviceClient().splitCloneFromParent(resourceGroupName, accountName, poolName, volumeName);
        if (inner != null) {
            return new VolumeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Volume splitCloneFromParent(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        VolumeInner inner = this.serviceClient().splitCloneFromParent(resourceGroupName, accountName, poolName, volumeName, context);
        if (inner != null) {
            return new VolumeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void breakFileLocks(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.serviceClient().breakFileLocks(resourceGroupName, accountName, poolName, volumeName);
    }

    @Override
    public void breakFileLocks(String resourceGroupName, String accountName, String poolName, String volumeName, BreakFileLocksRequest body, Context context) {
        this.serviceClient().breakFileLocks(resourceGroupName, accountName, poolName, volumeName, body, context);
    }

    @Override
    public GetGroupIdListForLdapUserResponse listGetGroupIdListForLdapUser(String resourceGroupName, String accountName, String poolName, String volumeName, GetGroupIdListForLdapUserRequest body) {
        GetGroupIdListForLdapUserResponseInner inner = this.serviceClient().listGetGroupIdListForLdapUser(resourceGroupName, accountName, poolName, volumeName, body);
        if (inner != null) {
            return new GetGroupIdListForLdapUserResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public GetGroupIdListForLdapUserResponse listGetGroupIdListForLdapUser(String resourceGroupName, String accountName, String poolName, String volumeName, GetGroupIdListForLdapUserRequest body, Context context) {
        GetGroupIdListForLdapUserResponseInner inner = this.serviceClient().listGetGroupIdListForLdapUser(resourceGroupName, accountName, poolName, volumeName, body, context);
        if (inner != null) {
            return new GetGroupIdListForLdapUserResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void breakReplication(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.serviceClient().breakReplication(resourceGroupName, accountName, poolName, volumeName);
    }

    @Override
    public void breakReplication(String resourceGroupName, String accountName, String poolName, String volumeName, BreakReplicationRequest body, Context context) {
        this.serviceClient().breakReplication(resourceGroupName, accountName, poolName, volumeName, body, context);
    }

    @Override
    public void reestablishReplication(String resourceGroupName, String accountName, String poolName, String volumeName, ReestablishReplicationRequest body) {
        this.serviceClient().reestablishReplication(resourceGroupName, accountName, poolName, volumeName, body);
    }

    @Override
    public void reestablishReplication(String resourceGroupName, String accountName, String poolName, String volumeName, ReestablishReplicationRequest body, Context context) {
        this.serviceClient().reestablishReplication(resourceGroupName, accountName, poolName, volumeName, body, context);
    }

    @Override
    public Response<ReplicationStatus> replicationStatusWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        Response<ReplicationStatusInner> inner = this.serviceClient().replicationStatusWithResponse(resourceGroupName, accountName, poolName, volumeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ReplicationStatusImpl((ReplicationStatusInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ReplicationStatus replicationStatus(String resourceGroupName, String accountName, String poolName, String volumeName) {
        ReplicationStatusInner inner = this.serviceClient().replicationStatus(resourceGroupName, accountName, poolName, volumeName);
        if (inner != null) {
            return new ReplicationStatusImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Replication> listReplications(String resourceGroupName, String accountName, String poolName, String volumeName) {
        PagedIterable<ReplicationInner> inner = this.serviceClient().listReplications(resourceGroupName, accountName, poolName, volumeName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReplicationImpl((ReplicationInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<Replication> listReplications(String resourceGroupName, String accountName, String poolName, String volumeName, ListReplicationsRequest body, Context context) {
        PagedIterable<ReplicationInner> inner = this.serviceClient().listReplications(resourceGroupName, accountName, poolName, volumeName, body, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReplicationImpl((ReplicationInner)inner1, this.manager()));
    }

    @Override
    public void resyncReplication(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.serviceClient().resyncReplication(resourceGroupName, accountName, poolName, volumeName);
    }

    @Override
    public void resyncReplication(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        this.serviceClient().resyncReplication(resourceGroupName, accountName, poolName, volumeName, context);
    }

    @Override
    public void deleteReplication(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.serviceClient().deleteReplication(resourceGroupName, accountName, poolName, volumeName);
    }

    @Override
    public void deleteReplication(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        this.serviceClient().deleteReplication(resourceGroupName, accountName, poolName, volumeName, context);
    }

    @Override
    public void authorizeReplication(String resourceGroupName, String accountName, String poolName, String volumeName, AuthorizeRequest body) {
        this.serviceClient().authorizeReplication(resourceGroupName, accountName, poolName, volumeName, body);
    }

    @Override
    public void authorizeReplication(String resourceGroupName, String accountName, String poolName, String volumeName, AuthorizeRequest body, Context context) {
        this.serviceClient().authorizeReplication(resourceGroupName, accountName, poolName, volumeName, body, context);
    }

    @Override
    public void reInitializeReplication(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.serviceClient().reInitializeReplication(resourceGroupName, accountName, poolName, volumeName);
    }

    @Override
    public void reInitializeReplication(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        this.serviceClient().reInitializeReplication(resourceGroupName, accountName, poolName, volumeName, context);
    }

    @Override
    public ClusterPeerCommandResponse peerExternalCluster(String resourceGroupName, String accountName, String poolName, String volumeName, PeerClusterForVolumeMigrationRequest body) {
        ClusterPeerCommandResponseInner inner = this.serviceClient().peerExternalCluster(resourceGroupName, accountName, poolName, volumeName, body);
        if (inner != null) {
            return new ClusterPeerCommandResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ClusterPeerCommandResponse peerExternalCluster(String resourceGroupName, String accountName, String poolName, String volumeName, PeerClusterForVolumeMigrationRequest body, Context context) {
        ClusterPeerCommandResponseInner inner = this.serviceClient().peerExternalCluster(resourceGroupName, accountName, poolName, volumeName, body, context);
        if (inner != null) {
            return new ClusterPeerCommandResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SvmPeerCommandResponse authorizeExternalReplication(String resourceGroupName, String accountName, String poolName, String volumeName) {
        SvmPeerCommandResponseInner inner = this.serviceClient().authorizeExternalReplication(resourceGroupName, accountName, poolName, volumeName);
        if (inner != null) {
            return new SvmPeerCommandResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SvmPeerCommandResponse authorizeExternalReplication(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        SvmPeerCommandResponseInner inner = this.serviceClient().authorizeExternalReplication(resourceGroupName, accountName, poolName, volumeName, context);
        if (inner != null) {
            return new SvmPeerCommandResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void finalizeExternalReplication(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.serviceClient().finalizeExternalReplication(resourceGroupName, accountName, poolName, volumeName);
    }

    @Override
    public void finalizeExternalReplication(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        this.serviceClient().finalizeExternalReplication(resourceGroupName, accountName, poolName, volumeName, context);
    }

    @Override
    public void performReplicationTransfer(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.serviceClient().performReplicationTransfer(resourceGroupName, accountName, poolName, volumeName);
    }

    @Override
    public void performReplicationTransfer(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        this.serviceClient().performReplicationTransfer(resourceGroupName, accountName, poolName, volumeName, context);
    }

    @Override
    public void poolChange(String resourceGroupName, String accountName, String poolName, String volumeName, PoolChangeRequest body) {
        this.serviceClient().poolChange(resourceGroupName, accountName, poolName, volumeName, body);
    }

    @Override
    public void poolChange(String resourceGroupName, String accountName, String poolName, String volumeName, PoolChangeRequest body, Context context) {
        this.serviceClient().poolChange(resourceGroupName, accountName, poolName, volumeName, body, context);
    }

    @Override
    public void relocate(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.serviceClient().relocate(resourceGroupName, accountName, poolName, volumeName);
    }

    @Override
    public void relocate(String resourceGroupName, String accountName, String poolName, String volumeName, RelocateVolumeRequest body, Context context) {
        this.serviceClient().relocate(resourceGroupName, accountName, poolName, volumeName, body, context);
    }

    @Override
    public void finalizeRelocation(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.serviceClient().finalizeRelocation(resourceGroupName, accountName, poolName, volumeName);
    }

    @Override
    public void finalizeRelocation(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        this.serviceClient().finalizeRelocation(resourceGroupName, accountName, poolName, volumeName, context);
    }

    @Override
    public void revertRelocation(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.serviceClient().revertRelocation(resourceGroupName, accountName, poolName, volumeName);
    }

    @Override
    public void revertRelocation(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        this.serviceClient().revertRelocation(resourceGroupName, accountName, poolName, volumeName, context);
    }

    @Override
    public Volume getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        return (Volume)this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, Context.NONE).getValue();
    }

    @Override
    public Response<Volume> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        Boolean localForceDelete = null;
        this.delete(resourceGroupName, accountName, poolName, volumeName, localForceDelete, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Boolean forceDelete, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, volumeName, forceDelete, context);
    }

    private VolumesClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public VolumeImpl define(String name) {
        return new VolumeImpl(name, this.manager());
    }
}

