/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.VolumeGroupsClient;
import com.azure.resourcemanager.netapp.fluent.models.VolumeGroupDetailsInner;
import com.azure.resourcemanager.netapp.fluent.models.VolumeGroupInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.implementation.VolumeGroupDetailsImpl;
import com.azure.resourcemanager.netapp.implementation.VolumeGroupImpl;
import com.azure.resourcemanager.netapp.models.VolumeGroup;
import com.azure.resourcemanager.netapp.models.VolumeGroupDetails;
import com.azure.resourcemanager.netapp.models.VolumeGroups;

public final class VolumeGroupsImpl
implements VolumeGroups {
    private static final ClientLogger LOGGER = new ClientLogger(VolumeGroupsImpl.class);
    private final VolumeGroupsClient innerClient;
    private final NetAppFilesManager serviceManager;

    public VolumeGroupsImpl(VolumeGroupsClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<VolumeGroupDetails> getWithResponse(String resourceGroupName, String accountName, String volumeGroupName, Context context) {
        Response<VolumeGroupDetailsInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, volumeGroupName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VolumeGroupDetailsImpl((VolumeGroupDetailsInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public VolumeGroupDetails get(String resourceGroupName, String accountName, String volumeGroupName) {
        VolumeGroupDetailsInner inner = this.serviceClient().get(resourceGroupName, accountName, volumeGroupName);
        if (inner != null) {
            return new VolumeGroupDetailsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String volumeGroupName) {
        this.serviceClient().delete(resourceGroupName, accountName, volumeGroupName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String volumeGroupName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, volumeGroupName, context);
    }

    @Override
    public PagedIterable<VolumeGroup> listByNetAppAccount(String resourceGroupName, String accountName) {
        PagedIterable<VolumeGroupInner> inner = this.serviceClient().listByNetAppAccount(resourceGroupName, accountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VolumeGroupImpl((VolumeGroupInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<VolumeGroup> listByNetAppAccount(String resourceGroupName, String accountName, Context context) {
        PagedIterable<VolumeGroupInner> inner = this.serviceClient().listByNetAppAccount(resourceGroupName, accountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VolumeGroupImpl((VolumeGroupInner)inner1, this.manager()));
    }

    @Override
    public VolumeGroupDetails getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String volumeGroupName = ResourceManagerUtils.getValueFromIdByName(id, "volumeGroups");
        if (volumeGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumeGroups'.", id)));
        }
        return (VolumeGroupDetails)this.getWithResponse(resourceGroupName, accountName, volumeGroupName, Context.NONE).getValue();
    }

    @Override
    public Response<VolumeGroupDetails> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String volumeGroupName = ResourceManagerUtils.getValueFromIdByName(id, "volumeGroups");
        if (volumeGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumeGroups'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, volumeGroupName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String volumeGroupName = ResourceManagerUtils.getValueFromIdByName(id, "volumeGroups");
        if (volumeGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumeGroups'.", id)));
        }
        this.delete(resourceGroupName, accountName, volumeGroupName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String volumeGroupName = ResourceManagerUtils.getValueFromIdByName(id, "volumeGroups");
        if (volumeGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumeGroups'.", id)));
        }
        this.delete(resourceGroupName, accountName, volumeGroupName, context);
    }

    private VolumeGroupsClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public VolumeGroupDetailsImpl define(String name) {
        return new VolumeGroupDetailsImpl(name, this.manager());
    }
}

