/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.SnapshotInner;
import com.azure.resourcemanager.netapp.models.Snapshot;
import com.azure.resourcemanager.netapp.models.SnapshotRestoreFiles;
import java.time.OffsetDateTime;

public final class SnapshotImpl
implements Snapshot,
Snapshot.Definition {
    private SnapshotInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String poolName;
    private String volumeName;
    private String snapshotName;

    SnapshotImpl(SnapshotInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String snapshotId() {
        return this.innerModel().snapshotId();
    }

    @Override
    public OffsetDateTime created() {
        return this.innerModel().created();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public SnapshotInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public SnapshotImpl withExistingVolume(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        this.poolName = poolName;
        this.volumeName = volumeName;
        return this;
    }

    @Override
    public Snapshot create() {
        this.innerObject = this.serviceManager.serviceClient().getSnapshots().create(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.snapshotName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Snapshot create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSnapshots().create(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.snapshotName, this.innerModel(), context);
        return this;
    }

    SnapshotImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new SnapshotInner();
        this.serviceManager = serviceManager;
        this.snapshotName = name;
    }

    @Override
    public Snapshot refresh() {
        this.innerObject = (SnapshotInner)((Object)this.serviceManager.serviceClient().getSnapshots().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.snapshotName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Snapshot refresh(Context context) {
        this.innerObject = (SnapshotInner)((Object)this.serviceManager.serviceClient().getSnapshots().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.snapshotName, context).getValue());
        return this;
    }

    @Override
    public void restoreFiles(SnapshotRestoreFiles body) {
        this.serviceManager.snapshots().restoreFiles(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.snapshotName, body);
    }

    @Override
    public void restoreFiles(SnapshotRestoreFiles body, Context context) {
        this.serviceManager.snapshots().restoreFiles(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.snapshotName, body, context);
    }

    @Override
    public SnapshotImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public SnapshotImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }
}

