/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.BackupInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.Backup;
import com.azure.resourcemanager.netapp.models.BackupPatch;
import com.azure.resourcemanager.netapp.models.BackupType;
import java.time.OffsetDateTime;

public final class BackupImpl
implements Backup,
Backup.Definition,
Backup.Update {
    private BackupInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String backupVaultName;
    private String backupName;
    private BackupPatch updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String backupId() {
        return this.innerModel().backupId();
    }

    @Override
    public OffsetDateTime creationDate() {
        return this.innerModel().creationDate();
    }

    @Override
    public OffsetDateTime snapshotCreationDate() {
        return this.innerModel().snapshotCreationDate();
    }

    @Override
    public OffsetDateTime completionDate() {
        return this.innerModel().completionDate();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Long size() {
        return this.innerModel().size();
    }

    @Override
    public String label() {
        return this.innerModel().label();
    }

    @Override
    public BackupType backupType() {
        return this.innerModel().backupType();
    }

    @Override
    public String failureReason() {
        return this.innerModel().failureReason();
    }

    @Override
    public String volumeResourceId() {
        return this.innerModel().volumeResourceId();
    }

    @Override
    public Boolean useExistingSnapshot() {
        return this.innerModel().useExistingSnapshot();
    }

    @Override
    public String snapshotName() {
        return this.innerModel().snapshotName();
    }

    @Override
    public String backupPolicyResourceId() {
        return this.innerModel().backupPolicyResourceId();
    }

    @Override
    public Boolean isLargeVolume() {
        return this.innerModel().isLargeVolume();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public BackupInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public BackupImpl withExistingBackupVault(String resourceGroupName, String accountName, String backupVaultName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        this.backupVaultName = backupVaultName;
        return this;
    }

    @Override
    public Backup create() {
        this.innerObject = this.serviceManager.serviceClient().getBackups().create(this.resourceGroupName, this.accountName, this.backupVaultName, this.backupName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Backup create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBackups().create(this.resourceGroupName, this.accountName, this.backupVaultName, this.backupName, this.innerModel(), context);
        return this;
    }

    BackupImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new BackupInner();
        this.serviceManager = serviceManager;
        this.backupName = name;
    }

    @Override
    public BackupImpl update() {
        this.updateBody = new BackupPatch();
        return this;
    }

    @Override
    public Backup apply() {
        this.innerObject = this.serviceManager.serviceClient().getBackups().update(this.resourceGroupName, this.accountName, this.backupVaultName, this.backupName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public Backup apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBackups().update(this.resourceGroupName, this.accountName, this.backupVaultName, this.backupName, this.updateBody, context);
        return this;
    }

    BackupImpl(BackupInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "netAppAccounts");
        this.backupVaultName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "backupVaults");
        this.backupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "backups");
    }

    @Override
    public Backup refresh() {
        this.innerObject = (BackupInner)((Object)this.serviceManager.serviceClient().getBackups().getWithResponse(this.resourceGroupName, this.accountName, this.backupVaultName, this.backupName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Backup refresh(Context context) {
        this.innerObject = (BackupInner)((Object)this.serviceManager.serviceClient().getBackups().getWithResponse(this.resourceGroupName, this.accountName, this.backupVaultName, this.backupName, context).getValue());
        return this;
    }

    @Override
    public BackupImpl withVolumeResourceId(String volumeResourceId) {
        this.innerModel().withVolumeResourceId(volumeResourceId);
        return this;
    }

    @Override
    public BackupImpl withLabel(String label) {
        if (this.isInCreateMode()) {
            this.innerModel().withLabel(label);
            return this;
        }
        this.updateBody.withLabel(label);
        return this;
    }

    @Override
    public BackupImpl withUseExistingSnapshot(Boolean useExistingSnapshot) {
        this.innerModel().withUseExistingSnapshot(useExistingSnapshot);
        return this;
    }

    @Override
    public BackupImpl withSnapshotName(String snapshotName) {
        this.innerModel().withSnapshotName(snapshotName);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

