/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ProvisioningState;
import com.azure.resourcemanager.netapp.models.Type;
import java.io.IOException;

public final class VolumeQuotaRulesProperties
implements JsonSerializable<VolumeQuotaRulesProperties> {
    private ProvisioningState provisioningState;
    private Long quotaSizeInKiBs;
    private Type quotaType;
    private String quotaTarget;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Long quotaSizeInKiBs() {
        return this.quotaSizeInKiBs;
    }

    public VolumeQuotaRulesProperties withQuotaSizeInKiBs(Long quotaSizeInKiBs) {
        this.quotaSizeInKiBs = quotaSizeInKiBs;
        return this;
    }

    public Type quotaType() {
        return this.quotaType;
    }

    public VolumeQuotaRulesProperties withQuotaType(Type quotaType) {
        this.quotaType = quotaType;
        return this;
    }

    public String quotaTarget() {
        return this.quotaTarget;
    }

    public VolumeQuotaRulesProperties withQuotaTarget(String quotaTarget) {
        this.quotaTarget = quotaTarget;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("quotaSizeInKiBs", (Number)this.quotaSizeInKiBs);
        jsonWriter.writeStringField("quotaType", this.quotaType == null ? null : this.quotaType.toString());
        jsonWriter.writeStringField("quotaTarget", this.quotaTarget);
        return jsonWriter.writeEndObject();
    }

    public static VolumeQuotaRulesProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeQuotaRulesProperties)jsonReader.readObject(reader -> {
            VolumeQuotaRulesProperties deserializedVolumeQuotaRulesProperties = new VolumeQuotaRulesProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedVolumeQuotaRulesProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("quotaSizeInKiBs".equals(fieldName)) {
                    deserializedVolumeQuotaRulesProperties.quotaSizeInKiBs = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("quotaType".equals(fieldName)) {
                    deserializedVolumeQuotaRulesProperties.quotaType = Type.fromString(reader.getString());
                    continue;
                }
                if ("quotaTarget".equals(fieldName)) {
                    deserializedVolumeQuotaRulesProperties.quotaTarget = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeQuotaRulesProperties;
        });
    }
}

