/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.VolumeQuotaRulesProperties;
import com.azure.resourcemanager.netapp.models.ProvisioningState;
import com.azure.resourcemanager.netapp.models.Type;
import java.io.IOException;
import java.util.Map;

public final class VolumeQuotaRuleInner
extends Resource {
    private VolumeQuotaRulesProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private VolumeQuotaRulesProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public VolumeQuotaRuleInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VolumeQuotaRuleInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Long quotaSizeInKiBs() {
        return this.innerProperties() == null ? null : this.innerProperties().quotaSizeInKiBs();
    }

    public VolumeQuotaRuleInner withQuotaSizeInKiBs(Long quotaSizeInKiBs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeQuotaRulesProperties();
        }
        this.innerProperties().withQuotaSizeInKiBs(quotaSizeInKiBs);
        return this;
    }

    public Type quotaType() {
        return this.innerProperties() == null ? null : this.innerProperties().quotaType();
    }

    public VolumeQuotaRuleInner withQuotaType(Type quotaType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeQuotaRulesProperties();
        }
        this.innerProperties().withQuotaType(quotaType);
        return this;
    }

    public String quotaTarget() {
        return this.innerProperties() == null ? null : this.innerProperties().quotaTarget();
    }

    public VolumeQuotaRuleInner withQuotaTarget(String quotaTarget) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeQuotaRulesProperties();
        }
        this.innerProperties().withQuotaTarget(quotaTarget);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VolumeQuotaRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeQuotaRuleInner)((Object)jsonReader.readObject(reader -> {
            VolumeQuotaRuleInner deserializedVolumeQuotaRuleInner = new VolumeQuotaRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVolumeQuotaRuleInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVolumeQuotaRuleInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVolumeQuotaRuleInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVolumeQuotaRuleInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVolumeQuotaRuleInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVolumeQuotaRuleInner.innerProperties = VolumeQuotaRulesProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedVolumeQuotaRuleInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeQuotaRuleInner;
        }));
    }
}

