/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.EncryptionType;
import com.azure.resourcemanager.netapp.models.QosType;
import com.azure.resourcemanager.netapp.models.ServiceLevel;
import java.io.IOException;

public final class PoolProperties
implements JsonSerializable<PoolProperties> {
    private String poolId;
    private long size;
    private ServiceLevel serviceLevel;
    private String provisioningState;
    private Float totalThroughputMibps;
    private Float utilizedThroughputMibps;
    private Integer customThroughputMibps;
    private QosType qosType;
    private Boolean coolAccess;
    private EncryptionType encryptionType;
    private static final ClientLogger LOGGER = new ClientLogger(PoolProperties.class);

    public String poolId() {
        return this.poolId;
    }

    public long size() {
        return this.size;
    }

    public PoolProperties withSize(long size) {
        this.size = size;
        return this;
    }

    public ServiceLevel serviceLevel() {
        return this.serviceLevel;
    }

    public PoolProperties withServiceLevel(ServiceLevel serviceLevel) {
        this.serviceLevel = serviceLevel;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Float totalThroughputMibps() {
        return this.totalThroughputMibps;
    }

    public Float utilizedThroughputMibps() {
        return this.utilizedThroughputMibps;
    }

    public Integer customThroughputMibps() {
        return this.customThroughputMibps;
    }

    public PoolProperties withCustomThroughputMibps(Integer customThroughputMibps) {
        this.customThroughputMibps = customThroughputMibps;
        return this;
    }

    public QosType qosType() {
        return this.qosType;
    }

    public PoolProperties withQosType(QosType qosType) {
        this.qosType = qosType;
        return this;
    }

    public Boolean coolAccess() {
        return this.coolAccess;
    }

    public PoolProperties withCoolAccess(Boolean coolAccess) {
        this.coolAccess = coolAccess;
        return this;
    }

    public EncryptionType encryptionType() {
        return this.encryptionType;
    }

    public PoolProperties withEncryptionType(EncryptionType encryptionType) {
        this.encryptionType = encryptionType;
        return this;
    }

    public void validate() {
        if (this.serviceLevel() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serviceLevel in model PoolProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("size", this.size);
        jsonWriter.writeStringField("serviceLevel", this.serviceLevel == null ? null : this.serviceLevel.toString());
        jsonWriter.writeNumberField("customThroughputMibps", (Number)this.customThroughputMibps);
        jsonWriter.writeStringField("qosType", this.qosType == null ? null : this.qosType.toString());
        jsonWriter.writeBooleanField("coolAccess", this.coolAccess);
        jsonWriter.writeStringField("encryptionType", this.encryptionType == null ? null : this.encryptionType.toString());
        return jsonWriter.writeEndObject();
    }

    public static PoolProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PoolProperties)jsonReader.readObject(reader -> {
            PoolProperties deserializedPoolProperties = new PoolProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("size".equals(fieldName)) {
                    deserializedPoolProperties.size = reader.getLong();
                    continue;
                }
                if ("serviceLevel".equals(fieldName)) {
                    deserializedPoolProperties.serviceLevel = ServiceLevel.fromString(reader.getString());
                    continue;
                }
                if ("poolId".equals(fieldName)) {
                    deserializedPoolProperties.poolId = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPoolProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("totalThroughputMibps".equals(fieldName)) {
                    deserializedPoolProperties.totalThroughputMibps = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("utilizedThroughputMibps".equals(fieldName)) {
                    deserializedPoolProperties.utilizedThroughputMibps = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("customThroughputMibps".equals(fieldName)) {
                    deserializedPoolProperties.customThroughputMibps = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("qosType".equals(fieldName)) {
                    deserializedPoolProperties.qosType = QosType.fromString(reader.getString());
                    continue;
                }
                if ("coolAccess".equals(fieldName)) {
                    deserializedPoolProperties.coolAccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("encryptionType".equals(fieldName)) {
                    deserializedPoolProperties.encryptionType = EncryptionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPoolProperties;
        });
    }
}

