/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.OperationProperties;
import com.azure.resourcemanager.netapp.models.OperationDisplay;
import com.azure.resourcemanager.netapp.models.ServiceSpecification;
import java.io.IOException;

public final class OperationInner
implements JsonSerializable<OperationInner> {
    private String name;
    private OperationDisplay display;
    private String origin;
    private OperationProperties innerProperties;

    private OperationInner() {
    }

    public String name() {
        return this.name;
    }

    public OperationDisplay display() {
        return this.display;
    }

    public String origin() {
        return this.origin;
    }

    private OperationProperties innerProperties() {
        return this.innerProperties;
    }

    public ServiceSpecification serviceSpecification() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceSpecification();
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        jsonWriter.writeStringField("origin", this.origin);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static OperationInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationInner)jsonReader.readObject(reader -> {
            OperationInner deserializedOperationInner = new OperationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOperationInner.name = reader.getString();
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedOperationInner.display = OperationDisplay.fromJson(reader);
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedOperationInner.origin = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedOperationInner.innerProperties = OperationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationInner;
        });
    }
}

