/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.fluent.models.NetAppAccountInner;
import com.azure.resourcemanager.netapp.models.AccountEncryption;
import com.azure.resourcemanager.netapp.models.ActiveDirectory;
import com.azure.resourcemanager.netapp.models.ChangeKeyVault;
import com.azure.resourcemanager.netapp.models.EncryptionTransitionRequest;
import com.azure.resourcemanager.netapp.models.GetKeyVaultStatusResponse;
import com.azure.resourcemanager.netapp.models.ManagedServiceIdentity;
import com.azure.resourcemanager.netapp.models.MultiAdStatus;
import java.util.List;
import java.util.Map;

public interface NetAppAccount {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public ManagedServiceIdentity identity();

    public SystemData systemData();

    public String provisioningState();

    public List<ActiveDirectory> activeDirectories();

    public AccountEncryption encryption();

    public Boolean disableShowmount();

    public String nfsV4IdDomain();

    public MultiAdStatus multiAdStatus();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public NetAppAccountInner innerModel();

    public Update update();

    public NetAppAccount refresh();

    public NetAppAccount refresh(Context var1);

    public void renewCredentials();

    public void renewCredentials(Context var1);

    public void transitionToCmk();

    public void transitionToCmk(EncryptionTransitionRequest var1, Context var2);

    public GetKeyVaultStatusResponse getChangeKeyVaultInformation();

    public GetKeyVaultStatusResponse getChangeKeyVaultInformation(Context var1);

    public void changeKeyVault();

    public void changeKeyVault(ChangeKeyVault var1, Context var2);

    public static interface UpdateStages {

        public static interface WithNfsV4IdDomain {
            public Update withNfsV4IdDomain(String var1);
        }

        public static interface WithEncryption {
            public Update withEncryption(AccountEncryption var1);
        }

        public static interface WithActiveDirectories {
            public Update withActiveDirectories(List<ActiveDirectory> var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithActiveDirectories,
    UpdateStages.WithEncryption,
    UpdateStages.WithNfsV4IdDomain {
        public NetAppAccount apply();

        public NetAppAccount apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithNfsV4IdDomain {
            public WithCreate withNfsV4IdDomain(String var1);
        }

        public static interface WithEncryption {
            public WithCreate withEncryption(AccountEncryption var1);
        }

        public static interface WithActiveDirectories {
            public WithCreate withActiveDirectories(List<ActiveDirectory> var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithActiveDirectories,
        WithEncryption,
        WithNfsV4IdDomain {
            public NetAppAccount create();

            public NetAppAccount create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

