/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.fluent.models.CapacityPoolInner;
import com.azure.resourcemanager.netapp.models.EncryptionType;
import com.azure.resourcemanager.netapp.models.QosType;
import com.azure.resourcemanager.netapp.models.ServiceLevel;
import java.util.Map;

public interface CapacityPool {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public SystemData systemData();

    public String poolId();

    public long size();

    public ServiceLevel serviceLevel();

    public String provisioningState();

    public Float totalThroughputMibps();

    public Float utilizedThroughputMibps();

    public Float customThroughputMibps();

    public QosType qosType();

    public Boolean coolAccess();

    public EncryptionType encryptionType();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public CapacityPoolInner innerModel();

    public Update update();

    public CapacityPool refresh();

    public CapacityPool refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithCustomThroughputMibps {
            public Update withCustomThroughputMibps(Float var1);
        }

        public static interface WithCoolAccess {
            public Update withCoolAccess(Boolean var1);
        }

        public static interface WithQosType {
            public Update withQosType(QosType var1);
        }

        public static interface WithSize {
            public Update withSize(Long var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithSize,
    UpdateStages.WithQosType,
    UpdateStages.WithCoolAccess,
    UpdateStages.WithCustomThroughputMibps {
        public CapacityPool apply();

        public CapacityPool apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithEncryptionType {
            public WithCreate withEncryptionType(EncryptionType var1);
        }

        public static interface WithCoolAccess {
            public WithCreate withCoolAccess(Boolean var1);
        }

        public static interface WithQosType {
            public WithCreate withQosType(QosType var1);
        }

        public static interface WithCustomThroughputMibps {
            public WithCreate withCustomThroughputMibps(Float var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithCustomThroughputMibps,
        WithQosType,
        WithCoolAccess,
        WithEncryptionType {
            public CapacityPool create();

            public CapacityPool create(Context var1);
        }

        public static interface WithServiceLevel {
            public WithCreate withServiceLevel(ServiceLevel var1);
        }

        public static interface WithSize {
            public WithServiceLevel withSize(long var1);
        }

        public static interface WithParentResource {
            public WithSize withExistingNetAppAccount(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithSize,
    DefinitionStages.WithServiceLevel,
    DefinitionStages.WithCreate {
    }
}

