/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.EncryptionIdentity;
import com.azure.resourcemanager.netapp.models.KeySource;
import com.azure.resourcemanager.netapp.models.KeyVaultProperties;
import java.io.IOException;

public final class AccountEncryption
implements JsonSerializable<AccountEncryption> {
    private KeySource keySource;
    private KeyVaultProperties keyVaultProperties;
    private EncryptionIdentity identity;

    public KeySource keySource() {
        return this.keySource;
    }

    public AccountEncryption withKeySource(KeySource keySource) {
        this.keySource = keySource;
        return this;
    }

    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public AccountEncryption withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public EncryptionIdentity identity() {
        return this.identity;
    }

    public AccountEncryption withIdentity(EncryptionIdentity identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keySource", this.keySource == null ? null : this.keySource.toString());
        jsonWriter.writeJsonField("keyVaultProperties", (JsonSerializable)this.keyVaultProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static AccountEncryption fromJson(JsonReader jsonReader) throws IOException {
        return (AccountEncryption)jsonReader.readObject(reader -> {
            AccountEncryption deserializedAccountEncryption = new AccountEncryption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keySource".equals(fieldName)) {
                    deserializedAccountEncryption.keySource = KeySource.fromString(reader.getString());
                    continue;
                }
                if ("keyVaultProperties".equals(fieldName)) {
                    deserializedAccountEncryption.keyVaultProperties = KeyVaultProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedAccountEncryption.identity = EncryptionIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccountEncryption;
        });
    }
}

