/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.VolumeGroupDetailsInner;
import com.azure.resourcemanager.netapp.models.VolumeGroupDetails;
import com.azure.resourcemanager.netapp.models.VolumeGroupMetadata;
import com.azure.resourcemanager.netapp.models.VolumeGroupVolumeProperties;
import java.util.Collections;
import java.util.List;

public final class VolumeGroupDetailsImpl
implements VolumeGroupDetails,
VolumeGroupDetails.Definition {
    private VolumeGroupDetailsInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String volumeGroupName;

    VolumeGroupDetailsImpl(VolumeGroupDetailsInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public VolumeGroupMetadata groupMetadata() {
        return this.innerModel().groupMetadata();
    }

    @Override
    public List<VolumeGroupVolumeProperties> volumes() {
        List<VolumeGroupVolumeProperties> inner = this.innerModel().volumes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public VolumeGroupDetailsInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public VolumeGroupDetailsImpl withExistingNetAppAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public VolumeGroupDetails create() {
        this.innerObject = this.serviceManager.serviceClient().getVolumeGroups().create(this.resourceGroupName, this.accountName, this.volumeGroupName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public VolumeGroupDetails create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVolumeGroups().create(this.resourceGroupName, this.accountName, this.volumeGroupName, this.innerModel(), context);
        return this;
    }

    VolumeGroupDetailsImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new VolumeGroupDetailsInner();
        this.serviceManager = serviceManager;
        this.volumeGroupName = name;
    }

    @Override
    public VolumeGroupDetails refresh() {
        this.innerObject = (VolumeGroupDetailsInner)this.serviceManager.serviceClient().getVolumeGroups().getWithResponse(this.resourceGroupName, this.accountName, this.volumeGroupName, Context.NONE).getValue();
        return this;
    }

    @Override
    public VolumeGroupDetails refresh(Context context) {
        this.innerObject = (VolumeGroupDetailsInner)this.serviceManager.serviceClient().getVolumeGroups().getWithResponse(this.resourceGroupName, this.accountName, this.volumeGroupName, context).getValue();
        return this;
    }

    @Override
    public VolumeGroupDetailsImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public VolumeGroupDetailsImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public VolumeGroupDetailsImpl withGroupMetadata(VolumeGroupMetadata groupMetadata) {
        this.innerModel().withGroupMetadata(groupMetadata);
        return this;
    }

    @Override
    public VolumeGroupDetailsImpl withVolumes(List<VolumeGroupVolumeProperties> volumes) {
        this.innerModel().withVolumes(volumes);
        return this;
    }
}

