/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.QosType;
import java.io.IOException;

public final class PoolPatchProperties
implements JsonSerializable<PoolPatchProperties> {
    private Long size;
    private QosType qosType;
    private Boolean coolAccess;
    private Float customThroughputMibps;

    public Long size() {
        return this.size;
    }

    public PoolPatchProperties withSize(Long size) {
        this.size = size;
        return this;
    }

    public QosType qosType() {
        return this.qosType;
    }

    public PoolPatchProperties withQosType(QosType qosType) {
        this.qosType = qosType;
        return this;
    }

    public Boolean coolAccess() {
        return this.coolAccess;
    }

    public PoolPatchProperties withCoolAccess(Boolean coolAccess) {
        this.coolAccess = coolAccess;
        return this;
    }

    public Float customThroughputMibps() {
        return this.customThroughputMibps;
    }

    public PoolPatchProperties withCustomThroughputMibps(Float customThroughputMibps) {
        this.customThroughputMibps = customThroughputMibps;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("size", (Number)this.size);
        jsonWriter.writeStringField("qosType", this.qosType == null ? null : this.qosType.toString());
        jsonWriter.writeBooleanField("coolAccess", this.coolAccess);
        jsonWriter.writeNumberField("customThroughputMibps", (Number)this.customThroughputMibps);
        return jsonWriter.writeEndObject();
    }

    public static PoolPatchProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PoolPatchProperties)jsonReader.readObject(reader -> {
            PoolPatchProperties deserializedPoolPatchProperties = new PoolPatchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("size".equals(fieldName)) {
                    deserializedPoolPatchProperties.size = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("qosType".equals(fieldName)) {
                    deserializedPoolPatchProperties.qosType = QosType.fromString(reader.getString());
                    continue;
                }
                if ("coolAccess".equals(fieldName)) {
                    deserializedPoolPatchProperties.coolAccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("customThroughputMibps".equals(fieldName)) {
                    deserializedPoolPatchProperties.customThroughputMibps = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPoolPatchProperties;
        });
    }
}

