/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ApplicationType;
import com.azure.resourcemanager.netapp.models.PlacementKeyValuePairs;
import java.io.IOException;
import java.util.List;

public final class VolumeGroupMetadata
implements JsonSerializable<VolumeGroupMetadata> {
    private String groupDescription;
    private ApplicationType applicationType;
    private String applicationIdentifier;
    private List<PlacementKeyValuePairs> globalPlacementRules;
    private Long volumesCount;

    public String groupDescription() {
        return this.groupDescription;
    }

    public VolumeGroupMetadata withGroupDescription(String groupDescription) {
        this.groupDescription = groupDescription;
        return this;
    }

    public ApplicationType applicationType() {
        return this.applicationType;
    }

    public VolumeGroupMetadata withApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
        return this;
    }

    public String applicationIdentifier() {
        return this.applicationIdentifier;
    }

    public VolumeGroupMetadata withApplicationIdentifier(String applicationIdentifier) {
        this.applicationIdentifier = applicationIdentifier;
        return this;
    }

    public List<PlacementKeyValuePairs> globalPlacementRules() {
        return this.globalPlacementRules;
    }

    public VolumeGroupMetadata withGlobalPlacementRules(List<PlacementKeyValuePairs> globalPlacementRules) {
        this.globalPlacementRules = globalPlacementRules;
        return this;
    }

    public Long volumesCount() {
        return this.volumesCount;
    }

    public void validate() {
        if (this.globalPlacementRules() != null) {
            this.globalPlacementRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("groupDescription", this.groupDescription);
        jsonWriter.writeStringField("applicationType", this.applicationType == null ? null : this.applicationType.toString());
        jsonWriter.writeStringField("applicationIdentifier", this.applicationIdentifier);
        jsonWriter.writeArrayField("globalPlacementRules", this.globalPlacementRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VolumeGroupMetadata fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeGroupMetadata)jsonReader.readObject(reader -> {
            VolumeGroupMetadata deserializedVolumeGroupMetadata = new VolumeGroupMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("groupDescription".equals(fieldName)) {
                    deserializedVolumeGroupMetadata.groupDescription = reader.getString();
                    continue;
                }
                if ("applicationType".equals(fieldName)) {
                    deserializedVolumeGroupMetadata.applicationType = ApplicationType.fromString(reader.getString());
                    continue;
                }
                if ("applicationIdentifier".equals(fieldName)) {
                    deserializedVolumeGroupMetadata.applicationIdentifier = reader.getString();
                    continue;
                }
                if ("globalPlacementRules".equals(fieldName)) {
                    List globalPlacementRules;
                    deserializedVolumeGroupMetadata.globalPlacementRules = globalPlacementRules = reader.readArray(reader1 -> PlacementKeyValuePairs.fromJson(reader1));
                    continue;
                }
                if ("volumesCount".equals(fieldName)) {
                    deserializedVolumeGroupMetadata.volumesCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeGroupMetadata;
        });
    }
}

