/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.fluent.models.SnapshotPolicyInner;
import com.azure.resourcemanager.netapp.models.DailySchedule;
import com.azure.resourcemanager.netapp.models.HourlySchedule;
import com.azure.resourcemanager.netapp.models.MonthlySchedule;
import com.azure.resourcemanager.netapp.models.WeeklySchedule;
import java.util.Map;

public interface SnapshotPolicy {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public SystemData systemData();

    public HourlySchedule hourlySchedule();

    public DailySchedule dailySchedule();

    public WeeklySchedule weeklySchedule();

    public MonthlySchedule monthlySchedule();

    public Boolean enabled();

    public String provisioningState();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public SnapshotPolicyInner innerModel();

    public Update update();

    public SnapshotPolicy refresh();

    public SnapshotPolicy refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithEnabled {
            public Update withEnabled(Boolean var1);
        }

        public static interface WithMonthlySchedule {
            public Update withMonthlySchedule(MonthlySchedule var1);
        }

        public static interface WithWeeklySchedule {
            public Update withWeeklySchedule(WeeklySchedule var1);
        }

        public static interface WithDailySchedule {
            public Update withDailySchedule(DailySchedule var1);
        }

        public static interface WithHourlySchedule {
            public Update withHourlySchedule(HourlySchedule var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithHourlySchedule,
    UpdateStages.WithDailySchedule,
    UpdateStages.WithWeeklySchedule,
    UpdateStages.WithMonthlySchedule,
    UpdateStages.WithEnabled {
        public SnapshotPolicy apply();

        public SnapshotPolicy apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithEnabled {
            public WithCreate withEnabled(Boolean var1);
        }

        public static interface WithMonthlySchedule {
            public WithCreate withMonthlySchedule(MonthlySchedule var1);
        }

        public static interface WithWeeklySchedule {
            public WithCreate withWeeklySchedule(WeeklySchedule var1);
        }

        public static interface WithDailySchedule {
            public WithCreate withDailySchedule(DailySchedule var1);
        }

        public static interface WithHourlySchedule {
            public WithCreate withHourlySchedule(HourlySchedule var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithHourlySchedule,
        WithDailySchedule,
        WithWeeklySchedule,
        WithMonthlySchedule,
        WithEnabled {
            public SnapshotPolicy create();

            public SnapshotPolicy create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingNetAppAccount(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

