/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.CheckNameResourceTypes;
import java.io.IOException;

public final class ResourceNameAvailabilityRequest
implements JsonSerializable<ResourceNameAvailabilityRequest> {
    private String name;
    private CheckNameResourceTypes type;
    private String resourceGroup;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceNameAvailabilityRequest.class);

    public String name() {
        return this.name;
    }

    public ResourceNameAvailabilityRequest withName(String name) {
        this.name = name;
        return this;
    }

    public CheckNameResourceTypes type() {
        return this.type;
    }

    public ResourceNameAvailabilityRequest withType(CheckNameResourceTypes type) {
        this.type = type;
        return this;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public ResourceNameAvailabilityRequest withResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ResourceNameAvailabilityRequest"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ResourceNameAvailabilityRequest"));
        }
        if (this.resourceGroup() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceGroup in model ResourceNameAvailabilityRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("resourceGroup", this.resourceGroup);
        return jsonWriter.writeEndObject();
    }

    public static ResourceNameAvailabilityRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceNameAvailabilityRequest)jsonReader.readObject(reader -> {
            ResourceNameAvailabilityRequest deserializedResourceNameAvailabilityRequest = new ResourceNameAvailabilityRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedResourceNameAvailabilityRequest.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedResourceNameAvailabilityRequest.type = CheckNameResourceTypes.fromString(reader.getString());
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedResourceNameAvailabilityRequest.resourceGroup = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceNameAvailabilityRequest;
        });
    }
}

