/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ActiveDirectoryStatus;
import com.azure.resourcemanager.netapp.models.LdapSearchScopeOpt;
import java.io.IOException;
import java.util.List;

public final class ActiveDirectory
implements JsonSerializable<ActiveDirectory> {
    private String activeDirectoryId;
    private String username;
    private String password;
    private String domain;
    private String dns;
    private ActiveDirectoryStatus status;
    private String statusDetails;
    private String smbServerName;
    private String organizationalUnit;
    private String site;
    private List<String> backupOperators;
    private List<String> administrators;
    private String kdcIp;
    private String adName;
    private String serverRootCACertificate;
    private Boolean aesEncryption;
    private Boolean ldapSigning;
    private List<String> securityOperators;
    private Boolean ldapOverTls;
    private Boolean allowLocalNfsUsersWithLdap;
    private Boolean encryptDCConnections;
    private LdapSearchScopeOpt ldapSearchScope;
    private String preferredServersForLdapClient;

    public String activeDirectoryId() {
        return this.activeDirectoryId;
    }

    public ActiveDirectory withActiveDirectoryId(String activeDirectoryId) {
        this.activeDirectoryId = activeDirectoryId;
        return this;
    }

    public String username() {
        return this.username;
    }

    public ActiveDirectory withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public ActiveDirectory withPassword(String password) {
        this.password = password;
        return this;
    }

    public String domain() {
        return this.domain;
    }

    public ActiveDirectory withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String dns() {
        return this.dns;
    }

    public ActiveDirectory withDns(String dns) {
        this.dns = dns;
        return this;
    }

    public ActiveDirectoryStatus status() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public String smbServerName() {
        return this.smbServerName;
    }

    public ActiveDirectory withSmbServerName(String smbServerName) {
        this.smbServerName = smbServerName;
        return this;
    }

    public String organizationalUnit() {
        return this.organizationalUnit;
    }

    public ActiveDirectory withOrganizationalUnit(String organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
        return this;
    }

    public String site() {
        return this.site;
    }

    public ActiveDirectory withSite(String site) {
        this.site = site;
        return this;
    }

    public List<String> backupOperators() {
        return this.backupOperators;
    }

    public ActiveDirectory withBackupOperators(List<String> backupOperators) {
        this.backupOperators = backupOperators;
        return this;
    }

    public List<String> administrators() {
        return this.administrators;
    }

    public ActiveDirectory withAdministrators(List<String> administrators) {
        this.administrators = administrators;
        return this;
    }

    public String kdcIp() {
        return this.kdcIp;
    }

    public ActiveDirectory withKdcIp(String kdcIp) {
        this.kdcIp = kdcIp;
        return this;
    }

    public String adName() {
        return this.adName;
    }

    public ActiveDirectory withAdName(String adName) {
        this.adName = adName;
        return this;
    }

    public String serverRootCACertificate() {
        return this.serverRootCACertificate;
    }

    public ActiveDirectory withServerRootCACertificate(String serverRootCACertificate) {
        this.serverRootCACertificate = serverRootCACertificate;
        return this;
    }

    public Boolean aesEncryption() {
        return this.aesEncryption;
    }

    public ActiveDirectory withAesEncryption(Boolean aesEncryption) {
        this.aesEncryption = aesEncryption;
        return this;
    }

    public Boolean ldapSigning() {
        return this.ldapSigning;
    }

    public ActiveDirectory withLdapSigning(Boolean ldapSigning) {
        this.ldapSigning = ldapSigning;
        return this;
    }

    public List<String> securityOperators() {
        return this.securityOperators;
    }

    public ActiveDirectory withSecurityOperators(List<String> securityOperators) {
        this.securityOperators = securityOperators;
        return this;
    }

    public Boolean ldapOverTls() {
        return this.ldapOverTls;
    }

    public ActiveDirectory withLdapOverTls(Boolean ldapOverTls) {
        this.ldapOverTls = ldapOverTls;
        return this;
    }

    public Boolean allowLocalNfsUsersWithLdap() {
        return this.allowLocalNfsUsersWithLdap;
    }

    public ActiveDirectory withAllowLocalNfsUsersWithLdap(Boolean allowLocalNfsUsersWithLdap) {
        this.allowLocalNfsUsersWithLdap = allowLocalNfsUsersWithLdap;
        return this;
    }

    public Boolean encryptDCConnections() {
        return this.encryptDCConnections;
    }

    public ActiveDirectory withEncryptDCConnections(Boolean encryptDCConnections) {
        this.encryptDCConnections = encryptDCConnections;
        return this;
    }

    public LdapSearchScopeOpt ldapSearchScope() {
        return this.ldapSearchScope;
    }

    public ActiveDirectory withLdapSearchScope(LdapSearchScopeOpt ldapSearchScope) {
        this.ldapSearchScope = ldapSearchScope;
        return this;
    }

    public String preferredServersForLdapClient() {
        return this.preferredServersForLdapClient;
    }

    public ActiveDirectory withPreferredServersForLdapClient(String preferredServersForLdapClient) {
        this.preferredServersForLdapClient = preferredServersForLdapClient;
        return this;
    }

    public void validate() {
        if (this.ldapSearchScope() != null) {
            this.ldapSearchScope().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("activeDirectoryId", this.activeDirectoryId);
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("domain", this.domain);
        jsonWriter.writeStringField("dns", this.dns);
        jsonWriter.writeStringField("smbServerName", this.smbServerName);
        jsonWriter.writeStringField("organizationalUnit", this.organizationalUnit);
        jsonWriter.writeStringField("site", this.site);
        jsonWriter.writeArrayField("backupOperators", this.backupOperators, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("administrators", this.administrators, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("kdcIP", this.kdcIp);
        jsonWriter.writeStringField("adName", this.adName);
        jsonWriter.writeStringField("serverRootCACertificate", this.serverRootCACertificate);
        jsonWriter.writeBooleanField("aesEncryption", this.aesEncryption);
        jsonWriter.writeBooleanField("ldapSigning", this.ldapSigning);
        jsonWriter.writeArrayField("securityOperators", this.securityOperators, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("ldapOverTLS", this.ldapOverTls);
        jsonWriter.writeBooleanField("allowLocalNfsUsersWithLdap", this.allowLocalNfsUsersWithLdap);
        jsonWriter.writeBooleanField("encryptDCConnections", this.encryptDCConnections);
        jsonWriter.writeJsonField("ldapSearchScope", (JsonSerializable)this.ldapSearchScope);
        jsonWriter.writeStringField("preferredServersForLdapClient", this.preferredServersForLdapClient);
        return jsonWriter.writeEndObject();
    }

    public static ActiveDirectory fromJson(JsonReader jsonReader) throws IOException {
        return (ActiveDirectory)jsonReader.readObject(reader -> {
            ActiveDirectory deserializedActiveDirectory = new ActiveDirectory();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("activeDirectoryId".equals(fieldName)) {
                    deserializedActiveDirectory.activeDirectoryId = reader.getString();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedActiveDirectory.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedActiveDirectory.password = reader.getString();
                    continue;
                }
                if ("domain".equals(fieldName)) {
                    deserializedActiveDirectory.domain = reader.getString();
                    continue;
                }
                if ("dns".equals(fieldName)) {
                    deserializedActiveDirectory.dns = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedActiveDirectory.status = ActiveDirectoryStatus.fromString(reader.getString());
                    continue;
                }
                if ("statusDetails".equals(fieldName)) {
                    deserializedActiveDirectory.statusDetails = reader.getString();
                    continue;
                }
                if ("smbServerName".equals(fieldName)) {
                    deserializedActiveDirectory.smbServerName = reader.getString();
                    continue;
                }
                if ("organizationalUnit".equals(fieldName)) {
                    deserializedActiveDirectory.organizationalUnit = reader.getString();
                    continue;
                }
                if ("site".equals(fieldName)) {
                    deserializedActiveDirectory.site = reader.getString();
                    continue;
                }
                if ("backupOperators".equals(fieldName)) {
                    List backupOperators;
                    deserializedActiveDirectory.backupOperators = backupOperators = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("administrators".equals(fieldName)) {
                    List administrators;
                    deserializedActiveDirectory.administrators = administrators = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("kdcIP".equals(fieldName)) {
                    deserializedActiveDirectory.kdcIp = reader.getString();
                    continue;
                }
                if ("adName".equals(fieldName)) {
                    deserializedActiveDirectory.adName = reader.getString();
                    continue;
                }
                if ("serverRootCACertificate".equals(fieldName)) {
                    deserializedActiveDirectory.serverRootCACertificate = reader.getString();
                    continue;
                }
                if ("aesEncryption".equals(fieldName)) {
                    deserializedActiveDirectory.aesEncryption = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("ldapSigning".equals(fieldName)) {
                    deserializedActiveDirectory.ldapSigning = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("securityOperators".equals(fieldName)) {
                    List securityOperators;
                    deserializedActiveDirectory.securityOperators = securityOperators = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("ldapOverTLS".equals(fieldName)) {
                    deserializedActiveDirectory.ldapOverTls = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allowLocalNfsUsersWithLdap".equals(fieldName)) {
                    deserializedActiveDirectory.allowLocalNfsUsersWithLdap = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("encryptDCConnections".equals(fieldName)) {
                    deserializedActiveDirectory.encryptDCConnections = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("ldapSearchScope".equals(fieldName)) {
                    deserializedActiveDirectory.ldapSearchScope = LdapSearchScopeOpt.fromJson(reader);
                    continue;
                }
                if ("preferredServersForLdapClient".equals(fieldName)) {
                    deserializedActiveDirectory.preferredServersForLdapClient = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActiveDirectory;
        });
    }
}

