/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.CapacityPoolInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.CapacityPool;
import com.azure.resourcemanager.netapp.models.CapacityPoolPatch;
import com.azure.resourcemanager.netapp.models.EncryptionType;
import com.azure.resourcemanager.netapp.models.QosType;
import com.azure.resourcemanager.netapp.models.ServiceLevel;
import java.util.Collections;
import java.util.Map;

public final class CapacityPoolImpl
implements CapacityPool,
CapacityPool.Definition,
CapacityPool.Update {
    private CapacityPoolInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String poolName;
    private CapacityPoolPatch updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String poolId() {
        return this.innerModel().poolId();
    }

    @Override
    public long size() {
        return this.innerModel().size();
    }

    @Override
    public ServiceLevel serviceLevel() {
        return this.innerModel().serviceLevel();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Float totalThroughputMibps() {
        return this.innerModel().totalThroughputMibps();
    }

    @Override
    public Float utilizedThroughputMibps() {
        return this.innerModel().utilizedThroughputMibps();
    }

    @Override
    public QosType qosType() {
        return this.innerModel().qosType();
    }

    @Override
    public Boolean coolAccess() {
        return this.innerModel().coolAccess();
    }

    @Override
    public EncryptionType encryptionType() {
        return this.innerModel().encryptionType();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public CapacityPoolInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public CapacityPoolImpl withExistingNetAppAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public CapacityPool create() {
        this.innerObject = this.serviceManager.serviceClient().getPools().createOrUpdate(this.resourceGroupName, this.accountName, this.poolName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public CapacityPool create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPools().createOrUpdate(this.resourceGroupName, this.accountName, this.poolName, this.innerModel(), context);
        return this;
    }

    CapacityPoolImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new CapacityPoolInner();
        this.serviceManager = serviceManager;
        this.poolName = name;
    }

    @Override
    public CapacityPoolImpl update() {
        this.updateBody = new CapacityPoolPatch();
        return this;
    }

    @Override
    public CapacityPool apply() {
        this.innerObject = this.serviceManager.serviceClient().getPools().update(this.resourceGroupName, this.accountName, this.poolName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public CapacityPool apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPools().update(this.resourceGroupName, this.accountName, this.poolName, this.updateBody, context);
        return this;
    }

    CapacityPoolImpl(CapacityPoolInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "netAppAccounts");
        this.poolName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "capacityPools");
    }

    @Override
    public CapacityPool refresh() {
        this.innerObject = (CapacityPoolInner)((Object)this.serviceManager.serviceClient().getPools().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, Context.NONE).getValue());
        return this;
    }

    @Override
    public CapacityPool refresh(Context context) {
        this.innerObject = (CapacityPoolInner)((Object)this.serviceManager.serviceClient().getPools().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, context).getValue());
        return this;
    }

    @Override
    public CapacityPoolImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public CapacityPoolImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public CapacityPoolImpl withSize(long size) {
        this.innerModel().withSize(size);
        return this;
    }

    @Override
    public CapacityPoolImpl withServiceLevel(ServiceLevel serviceLevel) {
        this.innerModel().withServiceLevel(serviceLevel);
        return this;
    }

    @Override
    public CapacityPoolImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBody.withTags((Map)tags);
        return this;
    }

    @Override
    public CapacityPoolImpl withQosType(QosType qosType) {
        if (this.isInCreateMode()) {
            this.innerModel().withQosType(qosType);
            return this;
        }
        this.updateBody.withQosType(qosType);
        return this;
    }

    @Override
    public CapacityPoolImpl withCoolAccess(Boolean coolAccess) {
        if (this.isInCreateMode()) {
            this.innerModel().withCoolAccess(coolAccess);
            return this;
        }
        this.updateBody.withCoolAccess(coolAccess);
        return this;
    }

    @Override
    public CapacityPoolImpl withEncryptionType(EncryptionType encryptionType) {
        this.innerModel().withEncryptionType(encryptionType);
        return this;
    }

    @Override
    public CapacityPoolImpl withSize(Long size) {
        this.updateBody.withSize(size);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

