/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.netapp.fluent.BackupsUnderBackupVaultsClient;
import com.azure.resourcemanager.netapp.implementation.NetAppManagementClientImpl;
import com.azure.resourcemanager.netapp.models.BackupRestoreFiles;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BackupsUnderBackupVaultsClientImpl
implements BackupsUnderBackupVaultsClient {
    private final BackupsUnderBackupVaultsService service;
    private final NetAppManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(BackupsUnderBackupVaultsClientImpl.class);

    BackupsUnderBackupVaultsClientImpl(NetAppManagementClientImpl client) {
        this.service = (BackupsUnderBackupVaultsService)RestProxy.create(BackupsUnderBackupVaultsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restoreFilesWithResponseAsync(String resourceGroupName, String accountName, String backupVaultName, String backupName, BackupRestoreFiles body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (backupVaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupVaultName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restoreFiles(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, backupVaultName, backupName, this.client.getApiVersion(), body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> restoreFilesWithResponse(String resourceGroupName, String accountName, String backupVaultName, String backupName, BackupRestoreFiles body) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (backupVaultName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter backupVaultName is required and cannot be null."));
        }
        if (backupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return this.service.restoreFilesSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, backupVaultName, backupName, this.client.getApiVersion(), body, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> restoreFilesWithResponse(String resourceGroupName, String accountName, String backupVaultName, String backupName, BackupRestoreFiles body, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (backupVaultName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter backupVaultName is required and cannot be null."));
        }
        if (backupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return this.service.restoreFilesSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, backupVaultName, backupName, this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRestoreFilesAsync(String resourceGroupName, String accountName, String backupVaultName, String backupName, BackupRestoreFiles body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restoreFilesWithResponseAsync(resourceGroupName, accountName, backupVaultName, backupName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestoreFiles(String resourceGroupName, String accountName, String backupVaultName, String backupName, BackupRestoreFiles body) {
        Response<BinaryData> response = this.restoreFilesWithResponse(resourceGroupName, accountName, backupVaultName, backupName, body);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestoreFiles(String resourceGroupName, String accountName, String backupVaultName, String backupName, BackupRestoreFiles body, Context context) {
        Response<BinaryData> response = this.restoreFilesWithResponse(resourceGroupName, accountName, backupVaultName, backupName, body, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> restoreFilesAsync(String resourceGroupName, String accountName, String backupVaultName, String backupName, BackupRestoreFiles body) {
        return this.beginRestoreFilesAsync(resourceGroupName, accountName, backupVaultName, backupName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restoreFiles(String resourceGroupName, String accountName, String backupVaultName, String backupName, BackupRestoreFiles body) {
        this.beginRestoreFiles(resourceGroupName, accountName, backupVaultName, backupName, body).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restoreFiles(String resourceGroupName, String accountName, String backupVaultName, String backupName, BackupRestoreFiles body, Context context) {
        this.beginRestoreFiles(resourceGroupName, accountName, backupVaultName, backupName, body, context).getFinalResult();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetAppManagementClientBackupsUnderBackupVaults")
    public static interface BackupsUnderBackupVaultsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/backupVaults/{backupVaultName}/backups/{backupName}/restoreFiles")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> restoreFiles(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="backupVaultName") String var5, @PathParam(value="backupName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") BackupRestoreFiles var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/backupVaults/{backupVaultName}/backups/{backupName}/restoreFiles")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> restoreFilesSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="backupVaultName") String var5, @PathParam(value="backupName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") BackupRestoreFiles var8, @HeaderParam(value="Accept") String var9, Context var10);
    }
}

