/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.BackupVaultsClient;
import com.azure.resourcemanager.netapp.fluent.models.BackupVaultInner;
import com.azure.resourcemanager.netapp.implementation.BackupVaultImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.BackupVault;
import com.azure.resourcemanager.netapp.models.BackupVaults;

public final class BackupVaultsImpl
implements BackupVaults {
    private static final ClientLogger LOGGER = new ClientLogger(BackupVaultsImpl.class);
    private final BackupVaultsClient innerClient;
    private final NetAppFilesManager serviceManager;

    public BackupVaultsImpl(BackupVaultsClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<BackupVault> listByNetAppAccount(String resourceGroupName, String accountName) {
        PagedIterable<BackupVaultInner> inner = this.serviceClient().listByNetAppAccount(resourceGroupName, accountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupVaultImpl((BackupVaultInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BackupVault> listByNetAppAccount(String resourceGroupName, String accountName, Context context) {
        PagedIterable<BackupVaultInner> inner = this.serviceClient().listByNetAppAccount(resourceGroupName, accountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupVaultImpl((BackupVaultInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<BackupVault> getWithResponse(String resourceGroupName, String accountName, String backupVaultName, Context context) {
        Response<BackupVaultInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, backupVaultName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BackupVaultImpl((BackupVaultInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public BackupVault get(String resourceGroupName, String accountName, String backupVaultName) {
        BackupVaultInner inner = this.serviceClient().get(resourceGroupName, accountName, backupVaultName);
        if (inner != null) {
            return new BackupVaultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String backupVaultName) {
        this.serviceClient().delete(resourceGroupName, accountName, backupVaultName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String backupVaultName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, backupVaultName, context);
    }

    @Override
    public BackupVault getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String backupVaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (backupVaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        return (BackupVault)this.getWithResponse(resourceGroupName, accountName, backupVaultName, Context.NONE).getValue();
    }

    @Override
    public Response<BackupVault> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String backupVaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (backupVaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, backupVaultName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String backupVaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (backupVaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        this.delete(resourceGroupName, accountName, backupVaultName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String backupVaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (backupVaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        this.delete(resourceGroupName, accountName, backupVaultName, context);
    }

    private BackupVaultsClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public BackupVaultImpl define(String name) {
        return new BackupVaultImpl(name, this.manager());
    }
}

