/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.VolumeGroupListProperties;
import com.azure.resourcemanager.netapp.models.VolumeGroupMetadata;
import java.io.IOException;

public final class VolumeGroupInner
implements JsonSerializable<VolumeGroupInner> {
    private String location;
    private String id;
    private String name;
    private String type;
    private VolumeGroupListProperties innerProperties;

    public String location() {
        return this.location;
    }

    public VolumeGroupInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    private VolumeGroupListProperties innerProperties() {
        return this.innerProperties;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public VolumeGroupMetadata groupMetadata() {
        return this.innerProperties() == null ? null : this.innerProperties().groupMetadata();
    }

    public VolumeGroupInner withGroupMetadata(VolumeGroupMetadata groupMetadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeGroupListProperties();
        }
        this.innerProperties().withGroupMetadata(groupMetadata);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VolumeGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeGroupInner)jsonReader.readObject(reader -> {
            VolumeGroupInner deserializedVolumeGroupInner = new VolumeGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedVolumeGroupInner.location = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedVolumeGroupInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVolumeGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVolumeGroupInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVolumeGroupInner.innerProperties = VolumeGroupListProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeGroupInner;
        });
    }
}

