/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.VolumeGroupProperties;
import com.azure.resourcemanager.netapp.models.VolumeGroupMetadata;
import com.azure.resourcemanager.netapp.models.VolumeGroupVolumeProperties;
import java.io.IOException;
import java.util.List;

public final class VolumeGroupDetailsInner
implements JsonSerializable<VolumeGroupDetailsInner> {
    private String location;
    private String id;
    private String name;
    private String type;
    private VolumeGroupProperties innerProperties;

    public String location() {
        return this.location;
    }

    public VolumeGroupDetailsInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    private VolumeGroupProperties innerProperties() {
        return this.innerProperties;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public VolumeGroupMetadata groupMetadata() {
        return this.innerProperties() == null ? null : this.innerProperties().groupMetadata();
    }

    public VolumeGroupDetailsInner withGroupMetadata(VolumeGroupMetadata groupMetadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeGroupProperties();
        }
        this.innerProperties().withGroupMetadata(groupMetadata);
        return this;
    }

    public List<VolumeGroupVolumeProperties> volumes() {
        return this.innerProperties() == null ? null : this.innerProperties().volumes();
    }

    public VolumeGroupDetailsInner withVolumes(List<VolumeGroupVolumeProperties> volumes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeGroupProperties();
        }
        this.innerProperties().withVolumes(volumes);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VolumeGroupDetailsInner fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeGroupDetailsInner)jsonReader.readObject(reader -> {
            VolumeGroupDetailsInner deserializedVolumeGroupDetailsInner = new VolumeGroupDetailsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedVolumeGroupDetailsInner.location = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedVolumeGroupDetailsInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVolumeGroupDetailsInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVolumeGroupDetailsInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVolumeGroupDetailsInner.innerProperties = VolumeGroupProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeGroupDetailsInner;
        });
    }
}

